/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cal;

import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalTableApproveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CalTableApproveValidator.class);

    public void validate() {
        ExtendedDataEntity[] entities;
        long startTime = System.currentTimeMillis();
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            DynamicObject data = entity.getDataEntity();
            String salaryFileNumber = data.getString("salaryfilev.number");
            String salaryFileStatus = data.getString("salaryfile.status");
            if (SWCStringUtils.equals((String)"E", (String)salaryFileStatus)) {
                String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u8be5\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u76f4\u63a5\u5ba1\u6279\u3002", (String)"CalTableApproveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber);
                this.addFatalErrorMessage(entity, errorMsg);
                continue;
            }
            if (this.checkOnHoldStatus(entity)) continue;
            String calState = data.getString("calstatus");
            if (CalStateEnum.AUDIT.getCode().equals(calState)) continue;
            String errorMsg = null;
            errorMsg = CalStateEnum.APPROVAL.getCode().equals(calState) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u518d\u76f4\u63a5\u5ba1\u6279\u3002", (String)"CalTableApproveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber) : (CalStateEnum.WAIT_APPROVALED.getCode().equals(calState) || CalStateEnum.APPROVALING.getCode().equals(calState) || CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calState) || CalStateEnum.APPROVALED.getCode().equals(calState) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u7684\u201c\u6838\u7b97\u72b6\u6001\u201d\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u76f4\u63a5\u5ba1\u6279\u3002", (String)"CalTableApproveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u7684\u201c\u6838\u7b97\u72b6\u6001\u201d\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u76f4\u63a5\u5ba1\u6279\u3002", (String)"CalTableApproveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber));
            this.addFatalErrorMessage(entity, errorMsg);
        }
        log.info("{}\u5ba1\u6279\u65f6\u6821\u9a8c\u5668\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getTraceId(), (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean checkOnHoldStatus(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        String onHoldStatus = data.getString("onholdstatus");
        String salaryFileNumber = data.getString("salaryfilev.number");
        if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(onHoldStatus)) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u7684\u201c\u505c\u7f13\u53d1\u72b6\u6001\u201d\u4e3a\u7ec8\u6b62\u53d1\u653e\uff0c\u65e0\u6cd5\u8fdb\u884c\u76f4\u63a5\u5ba1\u6279\u64cd\u4f5c\u3002", (String)"CalTableApproveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber);
            this.addFatalErrorMessage(entity, errorMsg);
            return true;
        }
        return false;
    }
}

