/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cloudcolla;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.HSASCloudCollaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import org.apache.commons.lang3.StringUtils;

public class PayRollActGrpValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            String msgListStr;
            this.checkIfFieldMapNotChoose(extendedDataEntity);
            Map variables = this.getOption().getVariables();
            if (CollectionUtils.isEmpty((Map)variables) || StringUtils.isEmpty((CharSequence)(msgListStr = (String)variables.get("batchValidPolicyResultMsgList")))) continue;
            try {
                List msgList = (List)SWCJSONUtils.cast((String)msgListStr, List.class, (Class[])new Class[]{String.class});
                for (String msg : msgList) {
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                }
            }
            catch (IOException e) {
                LOGGER.info("json\u89e3\u6790\u9519\u8bef", (Object)e);
            }
        }
    }

    private void checkIfFieldMapNotChoose(ExtendedDataEntity extendedDataEntity) {
        DynamicObject payRollGrpDyobj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryentities = payRollGrpDyobj.getDynamicObjectCollection("entryentity");
        Map payRollActIsMustFieldMapRel = HSASCloudCollaHelper.getInstance().getPayRollActGrpIsMustFieldMap(entryentities);
        if (!payRollActIsMustFieldMapRel.isEmpty()) {
            for (DynamicObject entryentity : entryentities) {
                this.validateFieldMapNotChoose(payRollActIsMustFieldMapRel, extendedDataEntity, entryentity);
            }
        }
    }

    private void validateFieldMapNotChoose(Map<String, Boolean> payRollActIsMustFieldMapRel, ExtendedDataEntity extendedDataEntity, DynamicObject entryEntity) {
        List collect;
        DynamicObject payRollActDyobj = entryEntity.getDynamicObject("payrollact");
        if (!payRollActIsMustFieldMapRel.get(payRollActDyobj.getString("id")).booleanValue()) {
            return;
        }
        SWCDataServiceHelper triggerCollaOrm = new SWCDataServiceHelper("hsas_triggercolla");
        DynamicObjectCollection triggerList = payRollActDyobj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)triggerList)) {
            return;
        }
        List triggerIds = triggerList.stream().map(obj -> obj.getDynamicObject("triggercolla").getLong("id")).collect(Collectors.toList());
        DynamicObject[] triggerObjs = triggerCollaOrm.query("ismustfieldmapping,entityobject", new QFilter[]{new QFilter("id", "in", triggerIds)});
        if (null == triggerObjs || triggerObjs.length == 0) {
            return;
        }
        ArrayList<String> mustMappedField = new ArrayList<String>();
        for (int i = 0; i < triggerObjs.length; ++i) {
            if (!"1".equals(triggerObjs[i].getString("ismustfieldmapping"))) continue;
            mustMappedField.add(triggerObjs[i].getString("entityobject.number"));
        }
        ArrayList isMappedField = new ArrayList();
        DynamicObjectCollection fielMapEntryEntity = entryEntity.getDynamicObjectCollection("subentryentity");
        if (!CollectionUtils.isEmpty((Collection)fielMapEntryEntity) && !CollectionUtils.isEmpty(collect = fielMapEntryEntity.stream().map(field -> field.getDynamicObjectCollection("actgfieldmapobj")).collect(Collectors.toList()))) {
            for (DynamicObjectCollection row : collect) {
                if (CollectionUtils.isEmpty((Collection)row)) continue;
                isMappedField.addAll(row.stream().map(objs -> objs.getString("fbasedataid.number")).collect(Collectors.toList()));
            }
        }
        ArrayList<String> msgStr = new ArrayList<String>();
        for (String field2 : mustMappedField) {
            if (isMappedField.contains(field2)) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)field2);
            msgStr.add(dataEntityType.getDisplayName().toString());
        }
        if (!CollectionUtils.isEmpty(msgStr)) {
            String join = String.join((CharSequence)"\u201d\u3001\u201c", msgStr);
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u9762\u677f\u7684\u201c{0}\u201d\u7684\u201c{1}\u201d\u672a\u9009\u62e9\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"PayRollActGrpValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), payRollActDyobj.getString("name"), join));
        }
    }
}

