/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.file;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryCaculateStyleValidator
extends AbstractValidator {
    private static final String ASSIGNED = "0";
    private static final String GENERAL = "1";

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap<Long, DynamicObject> databseDatas = new HashMap<Long, DynamicObject>(extendedDataEntities.length);
        HashSet<Long> numberSets = new HashSet<Long>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            this.checkIfFieldMapNotChoose(extendedDataEntity);
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            numberSets.add(dataEntity.getLong("id"));
        }
        this.validateCountryModify(extendedDataEntities, databseDatas, numberSets);
    }

    private void validateCountryModify(ExtendedDataEntity[] extendedDataEntities, Map<Long, DynamicObject> databseDatas, Set<Long> numberSets) {
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
        DynamicObject[] query = orm.query("id,countrytype,country,country.number", new QFilter[]{new QFilter("id", "in", numberSets)});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            databseDatas.put(dynamicObject.getLong("id"), dynamicObject);
        }
        this.checkCountryModify(extendedDataEntities, databseDatas);
    }

    private void checkCountryModify(ExtendedDataEntity[] extendedDataEntities, Map<Long, DynamicObject> databseDatas) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = dataEntity.getLong("id");
            DynamicObject dynamicObject = databseDatas.get(id);
            if (dynamicObject == null) continue;
            String lastCountryType = dynamicObject.getString("countrytype");
            String lastCountryNumber = dynamicObject.getString("country.number");
            String countryType = dataEntity.getString("countrytype");
            String countryNumber = dataEntity.getString("country.number");
            if (this.isEquale(lastCountryType, countryType) && this.isEquale(lastCountryNumber, countryNumber)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u201c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u201d\u548c\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u3002", (String)"SalaryCaculateStyleValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isEquale(String source, String target) {
        if (SWCStringUtils.isEmpty((String)source)) {
            source = "";
        }
        if (SWCStringUtils.isEmpty((String)target)) {
            target = "";
        }
        return source.equals(target);
    }

    private void checkIfFieldMapNotChoose(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        String countryType = dataEntity.getString("countrytype");
        if (GENERAL.equals(countryType)) {
            this.checkGeneralData(entity);
        }
        if (ASSIGNED.equals(countryType)) {
            this.checkAssignedData(entity);
        }
    }

    private void checkAssignedData(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        if (null == dataEntity) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDynamicObject("country");
        if (null == dynamicObject) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u9700\u8981\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5b57\u6bb5\u3002", (String)"SalaryCaculateStyleValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkGeneralData(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        if (null == dataEntity) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDynamicObject("country");
        if (null != dynamicObject) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u4e0d\u5141\u8bb8\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5b57\u6bb5\u3002", (String)"SalaryCaculateStyleValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }
}

