/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.formula;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.formula.FormulaParseService;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class FormulaSaveValidator
extends SWCDataBaseValidator {
    private static final Log logger = LogFactory.getLog(FormulaSaveValidator.class);
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String FIELD_AREATYPE_ASSIGN = "2";

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        boolean isImport = true;
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            isImport = false;
        }
        HashMap<Long, ExtendedDataEntity> importDataMap = new HashMap<Long, ExtendedDataEntity>(16);
        for (ExtendedDataEntity entity : dataEntities) {
            this.checkAreaTypeAndCountry(entity);
            if (!isImport) continue;
            DynamicObject formula = entity.getDataEntity();
            formula.set("isdraft", (Object)Boolean.TRUE);
            long id = formula.getLong("id");
            if (id == 0L) continue;
            importDataMap.put(id, entity);
        }
        if (importDataMap.size() == 0) {
            return;
        }
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        DynamicObjectCollection result = formulaHelper.queryOriginalCollection("id,number,status,areatype,country.id,isdraft,org.number,ctrlstrategy,usetype,salaryitem.number", new QFilter[]{new QFilter("id", "in", importDataMap.keySet())});
        if (result.size() == 0) {
            return;
        }
        DynamicObject tempObj = null;
        FormulaParseService formulaParse = new FormulaParseService();
        for (DynamicObject obj : result) {
            String subKey;
            String errorMsg;
            ExtendedDataEntity tempEntiry = (ExtendedDataEntity)importDataMap.get(obj.getLong("id"));
            if (tempEntiry == null) continue;
            tempObj = tempEntiry.getDataEntity();
            if ("B".equals(obj.getString("status"))) {
                errorMsg = ResManager.loadKDString((String)"\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)tempObj.getString("org.number"), (String)obj.getString("org.number"))) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)tempObj.getString("number"), (String)obj.getString("number"))) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u7f16\u7801\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)tempObj.getString("areatype"), (String)obj.getString("areatype"))) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if (tempObj.getLong("country.id") != obj.getLong("country.id")) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)tempObj.getString("ctrlstrategy"), (String)obj.getString("ctrlstrategy"))) {
                errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u63a7\u5236\u7b56\u7565\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(tempEntiry, errorMsg);
                continue;
            }
            if ("C".equals(obj.getString("status"))) {
                if (!SWCStringUtils.equals((String)tempObj.getString("usetype"), (String)obj.getString("usetype"))) {
                    errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u5ba1\u6838\u7684\u6570\u636e\u65f6\uff0c\u516c\u5f0f\u7528\u9014\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(tempEntiry, errorMsg);
                    continue;
                }
                if (!SWCStringUtils.equals((String)tempObj.getString("salaryitem.number"), (String)obj.getString("salaryitem.number"))) {
                    errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u5df2\u6709\u5ba1\u6838\u7684\u6570\u636e\u65f6\uff0c\u85aa\u916c\u9879\u76ee\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FormulaSaveValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(tempEntiry, errorMsg);
                    continue;
                }
            }
            if (obj.getBoolean("isdraft")) continue;
            if (FIELD_AREATYPE_GENERAL.equals(tempObj.getString("usetype"))) {
                subKey = "formulaForProration";
            } else {
                String calBlock = tempObj.getString("salaryitem.calblock");
                long countryId = tempObj.getLong("country.id");
                subKey = String.format(Locale.ROOT, "formulaitem_%s_%s", calBlock, countryId);
            }
            try {
                String appCacheKey = "formula_submit_" + UUID.randomUUID().toString();
                Map dataMap = FormulaDataServiceHelper.getAllItemDataForSubmit((DynamicObject)tempObj, (String)appCacheKey, (String)subKey);
                FormulaInfo formulaInfo = formulaParse.parseFormula(tempObj, dataMap);
            }
            catch (Exception exception) {
                logger.error("parseFormula error", (Throwable)exception);
                this.addErrorMessage(tempEntiry, ResManager.loadKDString((String)"\u516c\u5f0f\u4f53\u672a\u901a\u8fc7\u8ba1\u7b97\u516c\u5f0f\u8bed\u6cd5\u4fdd\u5b58\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\uff0c\u6216\u76f4\u63a5\u5728\u754c\u9762\u4e2d\u7f16\u8f91\u66f4\u65b0\u516c\u5f0f\u4f53\u3002", (String)"FormulaSaveValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkAreaTypeAndCountry(ExtendedDataEntity dataEntity) {
        DynamicObject obj = dataEntity.getDataEntity();
        String areatype = obj.getString("areatype");
        long countryId = obj.getLong("country.id");
        if (SWCStringUtils.isEmpty((String)areatype) || SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)areatype) && 0L == countryId || SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)areatype) && 0L != countryId) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
            return;
        }
        this.checkSalaryItemArea(dataEntity, obj);
    }

    private void checkSalaryItemArea(ExtendedDataEntity dataEntity, DynamicObject obj) {
        DynamicObject dynamicObject = obj.getDynamicObject("salaryitem");
        if (dynamicObject == null) {
            if (SWCStringUtils.equals((String)obj.getString("usetype"), (String)"0")) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u516c\u5f0f\u7528\u9014\u4e3a\u85aa\u916c\u9879\u76ee\u8ba1\u7b97\u65f6\uff0c\u85aa\u916c\u9879\u76ee\u4e3a\u5fc5\u586b\u3002", (String)"FormulaSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            return;
        }
        if (SWCStringUtils.equals((String)obj.getString("usetype"), (String)FIELD_AREATYPE_GENERAL)) {
            obj.set("salaryitem", null);
            return;
        }
        long itemCountryId = dynamicObject.getLong("country.id");
        long countryId = obj.getLong("country.id");
        String areatype = obj.getString("areatype");
        String itemAreatype = dynamicObject.getString("areatype");
        if (SWCStringUtils.isEmpty((String)itemAreatype)) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
            return;
        }
        if (SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)areatype)) {
            String errorMsg;
            if (!SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)itemAreatype)) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (0L != itemCountryId) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        } else if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)areatype)) {
            String errorMsg;
            if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)itemAreatype) && itemCountryId == 0L) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (0L != itemCountryId && itemCountryId != countryId) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)itemAreatype) && itemCountryId != 0L) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"FormulaSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

