/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.migrationtpl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.migrationtpl.MigrationTemplateHelper;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class MigrationTemplateValidator
extends SWCDataBaseValidator {
    public static final String regex = "[A-Z]*";

    public void validate() {
        String operateKey = this.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey)) {
            this.checkSaveAll();
        } else if (SWCStringUtils.equals((String)"submit", (String)operateKey)) {
            Map variables = this.getOption().getVariables();
            String isList = (String)variables.get("isList");
            if (StringUtils.equals((CharSequence)isList, (CharSequence)Boolean.FALSE.toString())) {
                this.checkSaveAll();
            } else {
                this.checkSubmitAll();
            }
        } else if (SWCStringUtils.equals((String)"unaudit", (String)operateKey)) {
            this.checkUnAuidt();
        }
    }

    private void checkUnAuidt() {
        List idList = Arrays.stream(this.dataEntities).map(dataEntitie -> dataEntitie.getDataEntity().getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObjectCollection importTasks = helper.queryOriginalCollection("migrationtpl.id", new QFilter[]{new QFilter("migrationtpl.id", "in", idList)});
        HashSet<Long> usedTemplateIdSet = new HashSet<Long>(idList.size());
        for (DynamicObject importTask : importTasks) {
            usedTemplateIdSet.add(importTask.getLong("migrationtpl.id"));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!usedTemplateIdSet.contains(dataEntity.getDataEntity().getLong("id"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u8fc1\u79fb\u4efb\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002\n", (String)"MigrationTemplateValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkSubmitAll() {
        ArrayList<Long> sLItemIdList = new ArrayList<Long>(10);
        ArrayList<Long> sPItemIdList = new ArrayList<Long>(10);
        ArrayList<Long> bSItemIdList = new ArrayList<Long>(10);
        ArrayList<Long> fTItemIdList = new ArrayList<Long>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection matchEntrys = data.getDynamicObjectCollection("hsas_migrationtplent");
            for (DynamicObject entry : matchEntrys) {
                String itemType = entry.getString("itemtype");
                if (SWCStringUtils.equals((String)itemType, (String)"1")) {
                    sLItemIdList.add(entry.getLong("itemid"));
                    continue;
                }
                if (SWCStringUtils.equals((String)itemType, (String)"2")) {
                    sPItemIdList.add(entry.getLong("itemid"));
                    continue;
                }
                if (SWCStringUtils.equals((String)itemType, (String)"3")) {
                    bSItemIdList.add(entry.getLong("itemid"));
                    continue;
                }
                if (!SWCStringUtils.equals((String)itemType, (String)"4")) continue;
                fTItemIdList.add(entry.getLong("itemid"));
            }
        }
        HashMap<String, Map<String, Object>> itemParamMapFromId = new HashMap<String, Map<String, Object>>(16);
        itemParamMapFromId.putAll(MigrationTemplateHelper.getItemParamMap(sLItemIdList, (String)"1", (String)"hsbs_salaryitem", null));
        itemParamMapFromId.putAll(MigrationTemplateHelper.getItemParamMap(sPItemIdList, (String)"2", (String)"hsbs_supportitem", null));
        itemParamMapFromId.putAll(MigrationTemplateHelper.getItemParamMap(bSItemIdList, (String)"3", (String)"hsbs_bizitem", null));
        itemParamMapFromId.putAll(MigrationTemplateHelper.getItemParamMap(fTItemIdList, (String)"4", (String)"hsbs_fetchitem", null));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkSubmit(dataEntity, itemParamMapFromId);
        }
    }

    private void checkSubmit(ExtendedDataEntity dataEntity, Map<String, Map<String, Object>> itemParamMapFromId) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection matchEntrys = data.getDynamicObjectCollection("hsas_migrationtplent");
        for (DynamicObject entry : matchEntrys) {
            String error;
            String key;
            Map<String, Object> itemParam;
            String itemType = entry.getString("itemtype");
            Long itemId = entry.getLong("itemid");
            String itemNumber = entry.getString("itemnumber");
            if (SWCStringUtils.equals((String)itemType, (String)"0") || (itemParam = itemParamMapFromId.get(key = itemType + '-' + itemId)) != null) continue;
            if (SWCStringUtils.equals((String)itemType, (String)"1")) {
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u85aa\u916c\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)itemType, (String)"2")) {
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u652f\u6301\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)itemType, (String)"3")) {
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u4e1a\u52a1\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else {
                if (!SWCStringUtils.equals((String)itemType, (String)"4")) continue;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u53d6\u6570\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            }
            error = MessageFormat.format(error, entry.getInt("seq"), itemNumber);
            this.addErrorMessage(dataEntity, error);
        }
    }

    private void checkSaveAll() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List<Long> idList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        Set<Long> existDataIdSet = this.getExistDataSet(idList);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            this.checkSave(dataEntity2, existDataIdSet.contains(dataEntity2.getDataEntity().getLong("id")));
        }
    }

    private void checkSave(ExtendedDataEntity dataEntity, boolean isExist) {
        DynamicObject data = dataEntity.getDataEntity();
        Integer startLine = data.getInt("startline");
        Integer endLine = data.getInt("endline");
        if (startLine <= 1 || endLine <= 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u8d77\u59cb\u884c\u4e0e\u6570\u636e\u7ed3\u675f\u884c\u5fc5\u987b\u5927\u4e8e1\u3002\n", (String)"MigrationTemplateValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        } else if (startLine > endLine) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7ed3\u675f\u884c\u4e0d\u80fd\u5c0f\u4e8e\u6570\u636e\u8d77\u59cb\u884c\u3002\n", (String)"MigrationTemplateValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        } else if (endLine - startLine > 1000000) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u8d77\u59cb\u884c\u4e0e\u6570\u636e\u7ed3\u675f\u884c\u7684\u5dee\u503c\u4e0d\u5f97\u8d85\u8fc7100\u4e07\u3002\n", (String)"MigrationTemplateValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
        this.checkEntry(dataEntity, isExist);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkEntry(ExtendedDataEntity dataEntity, boolean isExist) {
        Map variables;
        String isSave;
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection matchEntrys = data.getDynamicObjectCollection("hsas_migrationtplent");
        ArrayList<String> sLNumberList = new ArrayList<String>(matchEntrys.size());
        ArrayList<String> sPNumberList = new ArrayList<String>(matchEntrys.size());
        ArrayList<String> bSNumberList = new ArrayList<String>(matchEntrys.size());
        ArrayList<String> fTNumberList = new ArrayList<String>(matchEntrys.size());
        boolean hasUnPresetData = false;
        for (DynamicObject entry : matchEntrys) {
            String errorMsg;
            String itemNumber;
            block15: {
                String itemType = entry.getString("itemtype");
                String matchColumn = entry.getString("matchcolumn");
                itemNumber = entry.getString("itemnumber");
                if (!this.checkMatchColumn(matchColumn)) {
                    errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5bf9\u5e94\u5217\u53ea\u80fd\u7531\u5927\u5199\u5b57\u6bcd\u7ec4\u6210\u3002\n", (String)"MigrationTemplateValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, entry.getInt("seq"));
                    this.addErrorMessage(dataEntity, errorMsg);
                }
                if (SWCStringUtils.equals((String)itemType, (String)"1")) {
                    if (sLNumberList.contains(itemNumber)) {
                        errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u85aa\u916c\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u91cd\u590d\u5bfc\u5165\u3002\n", (String)"MigrationTemplateValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                        break block15;
                    } else {
                        sLNumberList.add(itemNumber);
                        hasUnPresetData = true;
                        continue;
                    }
                }
                if (SWCStringUtils.equals((String)itemType, (String)"2")) {
                    if (sPNumberList.contains(itemNumber)) {
                        errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u652f\u6301\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u91cd\u590d\u5bfc\u5165\u3002\n", (String)"MigrationTemplateValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                        break block15;
                    } else {
                        sPNumberList.add(itemNumber);
                        hasUnPresetData = true;
                        continue;
                    }
                }
                if (SWCStringUtils.equals((String)itemType, (String)"3")) {
                    if (bSNumberList.contains(itemNumber)) {
                        errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u4e1a\u52a1\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u91cd\u590d\u5bfc\u5165\u3002\n", (String)"MigrationTemplateValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                        break block15;
                    } else {
                        bSNumberList.add(itemNumber);
                        hasUnPresetData = true;
                        continue;
                    }
                }
                if (!SWCStringUtils.equals((String)itemType, (String)"4")) continue;
                if (fTNumberList.contains(itemNumber)) {
                    errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u53d6\u6570\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u91cd\u590d\u5bfc\u5165\u3002\n", (String)"MigrationTemplateValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                } else {
                    fTNumberList.add(itemNumber);
                    hasUnPresetData = true;
                    continue;
                }
            }
            errorMsg = MessageFormat.format(errorMsg, entry.getInt("seq"), itemNumber);
            this.addErrorMessage(dataEntity, errorMsg);
        }
        if (!hasUnPresetData) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u3002\n", (String)"MigrationTemplateValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)(isSave = (String)(variables = this.getOption().getVariables()).get("save")), (CharSequence)Boolean.TRUE.toString())) {
            return;
        }
        this.checkImportData(dataEntity, sLNumberList, sPNumberList, bSNumberList, fTNumberList, isExist);
    }

    private void checkImportData(ExtendedDataEntity dataEntity, List<String> sLNumberList, List<String> sPNumberList, List<String> bSNumberList, List<String> fTNumberList, boolean isExist) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection matchEntrys = data.getDynamicObjectCollection("hsas_migrationtplent");
        Long orgId = data.getDynamicObject("org").getLong("id");
        boolean isArchivedData = data.getBoolean("isarchiveddata");
        Map sLItemParamMap = MigrationTemplateHelper.getItemParamMap((String)"number", sLNumberList, (String)"1", (String)"hsbs_salaryitem", null, (Long)orgId);
        Map sPItemParamMap = MigrationTemplateHelper.getItemParamMap((String)"number", sPNumberList, (String)"2", (String)"hsbs_supportitem", null, (Long)orgId);
        Map bSItemParamMap = MigrationTemplateHelper.getItemParamMap((String)"number", bSNumberList, (String)"3", (String)"hsbs_bizitem", null, (Long)orgId);
        Map fTItemParamMap = MigrationTemplateHelper.getItemParamMap((String)"number", fTNumberList, (String)"4", (String)"hsbs_fetchitem", null, null);
        boolean checkResult = true;
        String writeTaskType = data.getString("writetasktype");
        int addSeqValue = 0;
        addSeqValue = SWCStringUtils.equals((String)writeTaskType, (String)"0") ? 4 : 12;
        SWCDataServiceHelper dataTypeHelper = new SWCDataServiceHelper("hsbs_datatype");
        for (DynamicObject entry : matchEntrys) {
            String error;
            Map itemParamMap;
            String itemType = entry.getString("itemtype");
            String itemNumber = entry.getString("itemnumber");
            if (SWCStringUtils.equals((String)itemType, (String)"1")) {
                itemParamMap = sLItemParamMap;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u85aa\u916c\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)itemType, (String)"2")) {
                itemParamMap = sPItemParamMap;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u652f\u6301\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)itemType, (String)"3")) {
                itemParamMap = bSItemParamMap;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u4e1a\u52a1\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)itemType, (String)"4")) {
                itemParamMap = fTItemParamMap;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u53d6\u6570\u9879\u76ee\u201d\u4e2d\u8be5\u201c{1}\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u3002\n", (String)"MigrationTemplateValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            } else {
                if (entry.getLong("itemid") != 0L) continue;
                error = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u9879\u76ee\u7c7b\u522b\u4e0d\u5b58\u5728\u3002\n", (String)"MigrationTemplateValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                error = MessageFormat.format(error, entry.getInt("seq"));
                this.addErrorMessage(dataEntity, error);
                continue;
            }
            error = MessageFormat.format(error, entry.getInt("seq"), itemNumber);
            Map itemParam = (Map)itemParamMap.get(itemNumber);
            if (itemParam == null) {
                checkResult = false;
                error = MessageFormat.format(error, itemNumber);
                this.addErrorMessage(dataEntity, error);
                continue;
            }
            entry.set("itemid", itemParam.get("id"));
            entry.set("datatype", (Object)dataTypeHelper.generateDynamicObject(itemParam.get("dataTypeId"), "id"));
            if (isArchivedData) continue;
            entry.set("seq", (Object)(entry.getInt("seq") + addSeqValue));
        }
        if (checkResult) {
            if (isExist) {
                this.clearPresetItem(matchEntrys);
            }
            this.createPresetEntry(matchEntrys, isArchivedData, writeTaskType);
        }
    }

    private void clearPresetItem(DynamicObjectCollection matchEntrys) {
        Iterator iterator = matchEntrys.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            if (!SWCStringUtils.equals((String)"0", (String)entry.getString("itemtype"))) continue;
            iterator.remove();
        }
    }

    private void createPresetEntry(DynamicObjectCollection matchEntrys, boolean isArchivedData, String writeTaskType) {
        if (!isArchivedData) {
            int index = 1;
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_migrationtpl");
            EntityType type = (EntityType)mainType.getAllEntities().get("hsas_migrationtplent");
            List presetItemEnumList = MigrationTemplateHelper.getPresetItemEnumList((String)writeTaskType);
            if (CollectionUtils.isEmpty((Collection)presetItemEnumList)) {
                return;
            }
            for (PresetItemEnum presetItemEnum : presetItemEnumList) {
                DynamicObject newEntry = (DynamicObject)type.createInstance();
                newEntry.set("seq", (Object)index);
                newEntry.set("matchcolumn", (Object)presetItemEnum.getMatchColumn());
                newEntry.set("itemtype", (Object)"0");
                newEntry.set("itemid", (Object)presetItemEnum.getItemId());
                newEntry.set("datatype", (Object)presetItemEnum.getDataTypeId());
                newEntry.set("comment", (Object)presetItemEnum.getComment().getLocaleString());
                matchEntrys.add((Object)newEntry);
                ++index;
            }
        }
    }

    private boolean checkMatchColumn(String matchColumn) {
        return Pattern.compile(regex).matcher(matchColumn).matches();
    }

    private Set<Long> getExistDataSet(List<Long> idLst) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_migrationtpl");
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", idLst)});
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return new HashSet<Long>(0);
        }
        return datas.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
    }
}

