/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.onhold;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class OnHoldBillUndoValidator
extends SWCDataBaseValidator {
    private static final String SWC_HSAS_OPPLUGIN = "swc-hsas-opplugin";
    private static final String SIMPLE_NAME = OnHoldBillUndoValidator.class.getSimpleName();

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> onHoldIdToEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject temObj = dataEntity.getDataEntity();
            onHoldIdToEntityMap.put(temObj.getLong("id"), dataEntity);
        }
        this.checkOnHoldStopPay(onHoldIdToEntityMap);
    }

    private void checkOnHoldStopPay(Map<Long, ExtendedDataEntity> onHoldIdToEntityMap) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", onHoldIdToEntityMap.keySet());
        for (DynamicObject dynamicObject : dynamicObjects = helper.query("id,status,caltask.number,person,salaryfile.number", new QFilter[]{qFilter})) {
            String onHoldStatus = dynamicObject.getString("status");
            if (SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()))) continue;
            String personName = dynamicObject.getString("person.person.name");
            String personNum = dynamicObject.getString("person.empnumber");
            String calTaskNum = dynamicObject.getString("caltask.number");
            String salaryFileNum = dynamicObject.getString("salaryfile.number");
            String msg = null;
            msg = SWCStringUtils.equals(null, (String)calTaskNum) ? MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848({2})\u4e0d\u4e3a\u7ec8\u6b62\u53d1\u653e\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_0"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum) : MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1({2})\u4e0d\u4e3a\u7ec8\u6b62\u53d1\u653e\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_1"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, calTaskNum);
            this.addFatalErrorMessage(onHoldIdToEntityMap.get(dynamicObject.getLong("id")), msg);
        }
    }
}

