/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.payrollgroup;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.swc.hsas.business.payrollgrp.helper.PayRollGrpHelper;
import kd.swc.hsas.common.enums.HSASErrInfoEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class PayrollGroupSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        boolean isUnneededCheck;
        Object[] dataEntities = this.getDataEntities();
        boolean bl = isUnneededCheck = SWCArrayUtils.isEmpty((Object[])dataEntities) || !"save".equals(this.getOperateType()) && !"submit".equals(this.getOperateType()) && !"audit".equals(this.getOperateType()) && !"donothing_confirmchange".equals(this.getOperateKey()) && !"confirmchange".equals(this.getOperateKey());
        if (isUnneededCheck || dataEntities.length == 0) {
            return;
        }
        for (Object extendedDataEntity : dataEntities) {
            DynamicObjectCollection payRollGrpMulSum;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!dataEntity.getBoolean("issalaryslipsum") || (payRollGrpMulSum = dataEntity.getDynamicObjectCollection("payrollgrpmulsum")) != null && payRollGrpMulSum.size() != 0) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5de5\u8d44\u6761\u6c47\u603b\u65b9\u6848\u201d\u3002", (String)"PayrollGroupSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
        HashSet<Long> payRollSceneIdSet = new HashSet<Long>(16);
        HashSet<Long> calListViewIdSet = new HashSet<Long>(16);
        HashSet<Long> salarySlipViewIdSet = new HashSet<Long>(16);
        HashSet salSlipSumViewIdSet = new HashSet(16);
        String prorationMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5206\u6bb5\u8ba1\u7b97\u4e3a\u201c\u53ef\u5206\u6bb5\u8ba1\u7b97\u201d\u65f6\uff0c\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u5fc5\u586b\u3002", (String)"PayrollGroupSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        String requiredMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u5fc5\u987b\u586b\u5199\u5206\u6bb5\u8ba1\u7b97\u3002", (String)"PayrollGroupSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (Object entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection payrollSceneCollection = dataEntity.getDynamicObjectCollection("payrollsceneentry");
            int index = 1;
            for (DynamicObject payrollSceneEntry : payrollSceneCollection) {
                boolean isPublishSalSlip;
                boolean isInvalid;
                String prorationCal;
                long payrollSceneId = payrollSceneEntry.getLong("payrollscene.id");
                payRollSceneIdSet.add(payrollSceneId);
                long calListViewId = payrollSceneEntry.getLong("callistview.id");
                if (calListViewId != 0L) {
                    calListViewIdSet.add(calListViewId);
                }
                if (SWCStringUtils.isEmpty((String)(prorationCal = payrollSceneEntry.getString("prorationcal")))) {
                    this.addErrorMessage((ExtendedDataEntity)entity, String.format(Locale.ROOT, requiredMsg, index));
                }
                if ("1".equals(prorationCal) && payrollSceneEntry.getLong("prorationgenrule.id") == 0L) {
                    this.addErrorMessage((ExtendedDataEntity)entity, String.format(Locale.ROOT, prorationMsg, index));
                }
                boolean bl2 = isInvalid = (isPublishSalSlip = "1".equals(payrollSceneEntry.getString("lssuepayslip"))) && (SWCStringUtils.isEmpty((String)payrollSceneEntry.getString("releasesalaryslip")) || HRObjectUtils.isEmpty((Object)payrollSceneEntry.getDynamicObject("salaryslipview")));
                if (isInvalid) {
                    this.addErrorMessage((ExtendedDataEntity)entity, HSASErrInfoEnum.PAYROLL_GROUP_ERROR_OF_SALARY_INFO_MUST_INPUTTED.getMsg(new Object[]{index}));
                }
                salarySlipViewIdSet.add(payrollSceneEntry.getLong("salaryslipview.id"));
                ++index;
            }
            salSlipSumViewIdSet.addAll(dataEntity.getDynamicObjectCollection("payrollgrpmulsum").stream().map(baseDataDy -> baseDataDy.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
        Set invalidPayRollSceneIds = PayRollGrpHelper.queryInValidEntityIds((String)"hsas_payrollscene", payRollSceneIdSet);
        Set invalidCalListViewIds = PayRollGrpHelper.queryInValidEntityIds((String)"hsas_callistview", calListViewIdSet);
        Set invalidSalarySlipViewIds = PayRollGrpHelper.queryInValidEntityIds((String)"hsbs_salaryslipview", salarySlipViewIdSet);
        Set invalidSalSlipSumViewIds = PayRollGrpHelper.queryInValidEntityIds((String)"hsbs_salslipsumview", salSlipSumViewIdSet);
        if (invalidPayRollSceneIds.isEmpty() && invalidCalListViewIds.isEmpty() && invalidSalarySlipViewIds.isEmpty() && invalidSalSlipSumViewIds.isEmpty()) {
            return;
        }
        this.checkBaseDataEnable((ExtendedDataEntity[])dataEntities, invalidPayRollSceneIds, invalidCalListViewIds, invalidSalarySlipViewIds, invalidSalSlipSumViewIds);
    }

    private void checkBaseDataEnable(ExtendedDataEntity[] dataEntities, Set<Long> invalidPayRollSceneIds, Set<Long> invalidCalListViewIds, Set<Long> invalidSalarySlipViewIds, Set<Long> invalidSalSlipSumViewIds) {
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            for (DynamicObject payrollSceneEntry : extendedDataEntity.getDataEntity().getDynamicObjectCollection("payrollsceneentry")) {
                int seq = payrollSceneEntry.getInt("seq");
                if (invalidPayRollSceneIds.contains(payrollSceneEntry.getLong("payrollscene.id"))) {
                    this.addFatalErrorMessage(extendedDataEntity, HSASErrInfoEnum.PAYROLL_GROUP_ERROR_OF_SCENE_DISABLE.getMsg(new Object[]{String.valueOf(seq)}));
                }
                if (invalidCalListViewIds.contains(payrollSceneEntry.getLong("callistview.id"))) {
                    this.addFatalErrorMessage(extendedDataEntity, HSASErrInfoEnum.PAYROLL_GROUP_ERROR_OF_CAL_LIST_VIEW_DISABLE.getMsg(new Object[]{String.valueOf(seq)}));
                }
                if (!invalidSalarySlipViewIds.contains(payrollSceneEntry.getLong("salaryslipview.id"))) continue;
                this.addFatalErrorMessage(extendedDataEntity, HSASErrInfoEnum.PAYROLL_GROUP_ERROR_OF_SALARY_SLIP_VIEW_DISABLE.getMsg(new Object[]{String.valueOf(seq)}));
            }
            String invalidSalSlipSumError = extendedDataEntity.getDataEntity().getDynamicObjectCollection("payrollgrpmulsum").stream().filter(baseDataDy -> invalidSalSlipSumViewIds.contains(baseDataDy.getLong("fbasedataid.id"))).map(baseDataDy -> baseDataDy.getString("fbasedataid.name")).collect(Collectors.joining(","));
            if (invalidSalSlipSumError.length() <= 0) continue;
            this.addFatalErrorMessage(extendedDataEntity, HSASErrInfoEnum.PAYROLL_GROUP_ERROR_OF_SUM_CAS_VIEW_DISABLE.getMsg(new Object[]{invalidSalSlipSumError}));
        }
    }
}

