/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.payschedule;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class PayScheduleSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length < 1) {
            return;
        }
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject paySchDy = extendedDataEntity.getDataEntity();
            if (paySchDy.getDate("startdate") == null) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"PayScheduleSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date endDate = paySchDy.getDate("enddate");
            if (endDate == null) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PayScheduleSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (endDate.before(paySchDy.getDate("startdate"))) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u7684\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PayScheduleSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (currentDate.after(endDate) && !format.format(currentDate).equals(format.format(endDate))) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u8fc7\u53bb\u65e5\u671f\u7684\u65e5\u7a0b\u3002", (String)"PayScheduleSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            long payrollGrpId = paySchDy.getLong("payrollgrp.id");
            long payrollGrpvId = paySchDy.getLong("payrollgrpv.id");
            long payrollSceneId = paySchDy.getLong("payrollscene.id");
            QFilter grpvFilter = new QFilter("id", "=", (Object)payrollGrpvId);
            BaseDataHisHelper.addHisVerFilter((QFilter)grpvFilter);
            SWCDataServiceHelper helperPayRollGrp = new SWCDataServiceHelper("hsas_payrollgrp");
            DynamicObject payrollGrpV = helperPayRollGrp.queryOne("boid,payrollsceneentry,payrollscene.id", grpvFilter.toArray());
            if (payrollGrpV == null) {
                this.addMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u4e0d\u5b58\u5728\u3002", (String)"PayScheduleSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), paySchDy.getString("payrollgrpv.name")));
                continue;
            }
            if (payrollGrpV.getLong("boid") != payrollGrpId) {
                this.addMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0b\u65e0\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u201c{1}\u201d\u3002", (String)"PayScheduleSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]), paySchDy.getString("payrollgrp.name"), paySchDy.getString("payrollgrpv.name")));
                continue;
            }
            DynamicObjectCollection payrollSceneEntry = payrollGrpV.getDynamicObjectCollection("payrollsceneentry");
            HashSet<Long> payrollSceneIds = new HashSet<Long>(16);
            for (DynamicObject entry : payrollSceneEntry) {
                payrollSceneIds.add(entry.getLong("payrollscene.id"));
            }
            if (payrollSceneIds.contains(payrollSceneId)) continue;
            this.addMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u4e0b\u65e0\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201c{1}\u201d\u3002", (String)"PayScheduleSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]), paySchDy.getString("payrollgrpv.name"), paySchDy.getString("payrollscene.name")));
        }
    }
}

