/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.personchange;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.personchange.PersonChangeServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class PersonChangeGenProrationValidator
extends SWCDataBaseValidator {
    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashSet<Long> errorIds = new HashSet<Long>(dataEntities.length);
        this.validateStatus((ExtendedDataEntity[])dataEntities, errorIds);
        this.validateGeneratedProrationEvent((ExtendedDataEntity[])dataEntities, errorIds);
        this.invokeGenerateProrationEvent((ExtendedDataEntity[])dataEntities, errorIds);
    }

    private void validateStatus(ExtendedDataEntity[] extendedDataEntities, Set<Long> errorIds) {
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u8be5\u53d8\u52a8\u8bb0\u5f55\u5df2\u5e9f\u5f03\uff0c\u4e0d\u80fd\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"PersonChangeGenProrationValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!"0".equals(dataEntity.getString("status"))) continue;
            this.addErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, dataEntity.getString("number")));
            errorIds.add(dataEntity.getLong("id"));
        }
    }

    private void validateGeneratedProrationEvent(ExtendedDataEntity[] extendedDataEntities, Set<Long> errorIds) {
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u5df2\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"PersonChangeGenProrationValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!"1".equals(dataEntity.getString("generatedstatus"))) continue;
            this.addErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, dataEntity.getString("number")));
            errorIds.add(dataEntity.getLong("id"));
        }
    }

    private void invokeGenerateProrationEvent(ExtendedDataEntity[] extendedDataEntities, Set<Long> errorIds) {
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(extendedDataEntities.length);
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            if (errorIds.contains(extendedDataEntities[i].getDataEntity().getLong("id"))) continue;
            dataEntities.add(extendedDataEntities[i].getDataEntity());
        }
        if (CollectionUtils.isEmpty(dataEntities)) {
            return;
        }
        List result = PersonChangeServiceHelper.generateProrationEvent((DynamicObject[])dataEntities.toArray(new DynamicObject[dataEntities.size()]));
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        Map<Long, String> failMap = result.stream().filter(map -> (Boolean)map.get("success") == false).collect(Collectors.toMap(map -> (Long)map.get("personChange"), map -> (String)map.get("message"), (k1, k2) -> k1));
        String errorMsg = "{0}\uff1a{1}";
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long pkId = dataEntity.getLong("id");
            String message = failMap.get(pkId);
            if (null == message) continue;
            this.addErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, dataEntity.getString("number"), message));
        }
    }
}

