/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.prorationevent;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.swc.hsas.business.prorationevent.ProrationEventUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class ProrationEventSaveValidators
extends SWCDataBaseValidator {
    private static Log logger = LogFactory.getLog(ProrationEventSaveValidators.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        boolean isImport = true;
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            isImport = false;
        }
        Map<Long, DynamicObject> dbExistDataMap = this.getDbExistDataMap(dataEntities);
        ArrayList<ExtendedDataEntity> dataList = new ArrayList<ExtendedDataEntity>(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (this.checkIsEmpty(dataEntity, dataEntity.getDataEntity()) || !this.checkProrationDate(dataEntity) || !this.checkIsCanModify(dbExistDataMap, dataEntity)) continue;
            dataList.add(dataEntity);
        }
        if (isImport) {
            this.checkImportData(dataList);
        }
    }

    private Map<String, DynamicObject> getRepeatDataMap(Set<Long> genRuleIdSet, Set<Long> fileIdSet, Set<Long> reasonIdSet, Set<Date> prorationDateSet, Set<Long> idSet) {
        QFilter filter = new QFilter("salaryfile.id", "in", fileIdSet);
        filter.and("prorationgenrule.id", "in", genRuleIdSet);
        filter.and("changereason.id", "in", reasonIdSet);
        filter.and("id", "not in", idSet);
        filter.and("eventstatus", "=", (Object)"1");
        QFilter dateFilter = null;
        for (Date temp : prorationDateSet) {
            if (dateFilter == null) {
                dateFilter = new QFilter("prorationdate", "=", (Object)temp);
                continue;
            }
            dateFilter.or("prorationdate", "=", (Object)temp);
        }
        filter.and(dateFilter);
        return ProrationEventUtils.getProrationEventMap((QFilter)filter);
    }

    private Map<Long, Long> getHasPermsFileData(Set<Long> fileIdSet) {
        logger.info("getHasPermsFileData start");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", fileIdSet);
        logger.info("getDataRuleForBdProp start");
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_prorationevent", (String)"salaryfile");
        if (dataFilter != null) {
            filter.and(dataFilter);
        }
        logger.info("getDataRuleForBdProp end");
        logger.info("getPermOrgs start");
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_prorationevent", (String)"47150e89000000ac");
        logger.info("getPermOrgs end");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            filter.and(new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        DynamicObjectCollection result = helper.queryOriginalCollection("id,org.id", new QFilter[]{filter});
        logger.info("getHasPermsFileData end");
        return result.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("org.id")));
    }

    private void checkImportData(List<ExtendedDataEntity> dataEntities) {
        logger.info("checkImportData start");
        if (dataEntities.size() == 0) {
            return;
        }
        HashMap<String, ArrayList<ExtendedDataEntity>> dataEntityMap = new HashMap<String, ArrayList<ExtendedDataEntity>>(dataEntities.size());
        HashSet<Long> genRuleIdSet = new HashSet<Long>(dataEntities.size());
        HashSet<Long> fileIdSet = new HashSet<Long>(dataEntities.size());
        HashSet<Long> reasonIdSet = new HashSet<Long>(dataEntities.size());
        HashSet<Date> prorationDateSet = new HashSet<Date>(dataEntities.size());
        HashSet<Long> idSet = new HashSet<Long>(dataEntities.size());
        List tempList = null;
        String mapKey = null;
        for (ExtendedDataEntity entity : dataEntities) {
            genRuleIdSet.add(entity.getDataEntity().getLong("prorationgenrule.id"));
            fileIdSet.add(entity.getDataEntity().getLong("salaryfile.id"));
            reasonIdSet.add(entity.getDataEntity().getLong("changereason.id"));
            prorationDateSet.add(entity.getDataEntity().getDate("prorationdate"));
            idSet.add(entity.getDataEntity().getLong("id"));
            mapKey = ProrationEventUtils.getMapKey((DynamicObject)entity.getDataEntity());
            tempList = (ArrayList<ExtendedDataEntity>)dataEntityMap.get(mapKey);
            if (tempList == null) {
                tempList = new ArrayList<ExtendedDataEntity>(10);
                dataEntityMap.put(mapKey, (ArrayList<ExtendedDataEntity>)tempList);
            }
            tempList.add(entity);
        }
        Map<Long, Long> hasPermsFileMap = this.getHasPermsFileData(fileIdSet);
        Map<Object, Object> eventMap = new HashMap(16);
        HashMap<Long, Map<Long, DynamicObject>> genRuleEntryMap = new HashMap<Long, Map<Long, DynamicObject>>(dataEntities.size());
        Map<Object, Object> genRuleMap = new HashMap(16);
        if (hasPermsFileMap.size() > 0) {
            logger.info("getRepeatDataMap start");
            eventMap = this.getRepeatDataMap(genRuleIdSet, hasPermsFileMap.keySet(), reasonIdSet, prorationDateSet, idSet);
            logger.info("getRepeatDataMap end");
            genRuleMap = this.getProrationGenRuleData(genRuleIdSet, genRuleEntryMap, hasPermsFileMap);
            logger.info("getProrationGenRuleData end");
        }
        Map tempEntryMap = null;
        DynamicObject prorationEvent = null;
        DynamicObject genRuleObj = null;
        DynamicObject entryObj = null;
        for (ExtendedDataEntity entity : dataEntities) {
            String errorMsg;
            prorationEvent = entity.getDataEntity();
            if (!hasPermsFileMap.containsKey(prorationEvent.getLong("salaryfile.id"))) {
                errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            genRuleObj = (DynamicObject)genRuleMap.get(prorationEvent.getLong("prorationgenrule.id"));
            if (genRuleObj == null) {
                errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u7684\u4f7f\u7528\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (genRuleObj.getLong("country.id") != prorationEvent.getLong("salaryfile.payrollregion.id")) {
                errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7684\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u4e0e\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            tempEntryMap = (Map)genRuleEntryMap.get(prorationEvent.getLong("prorationgenrule.id"));
            entryObj = (DynamicObject)tempEntryMap.get(prorationEvent.getLong("changereason.id"));
            if (entryObj == null) {
                errorMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e0e\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u5185\u89c4\u5219\u8bbe\u7f6e\u7684\u6570\u636e\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            tempList = (List)dataEntityMap.get(ProrationEventUtils.getMapKey((DynamicObject)prorationEvent));
            if (tempList != null && tempList.size() > 1) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6863\u6848\u3001\u5206\u6bb5\u65e5\u671f\u3001\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u548c\u53d8\u52a8\u539f\u56e0\u5728\u6587\u4ef6\u4e2d\u5b58\u5728{0}\u6761\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_14", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, MessageFormat.format(errorMsg, tempList.size()));
                continue;
            }
            if (eventMap.containsKey(ProrationEventUtils.getMapKey((DynamicObject)prorationEvent))) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u201c\u6863\u6848\u201d\u3001\u201c\u5206\u6bb5\u65e5\u671f\u201d\u3001\u201c\u53d8\u52a8\u539f\u56e0\u201d\uff0c\u201c\u5206\u6bb5\u7c7b\u578b\u201d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            prorationEvent.set("prorationtype", (Object)entryObj.getString("prorationtype"));
            ProrationEventUtils.setMulBaseDataFieldValue((DynamicObjectCollection)entryObj.getDynamicObjectCollection("prorationitem"), (DynamicObject)prorationEvent);
        }
        logger.info("checkImportData end");
    }

    private boolean checkIsEmpty(ExtendedDataEntity entity, DynamicObject prorationEvent) {
        if (prorationEvent.getLong("salaryfile.id") == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u5fc5\u586b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return true;
        }
        if (prorationEvent.getLong("prorationgenrule.id") == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u5fc5\u586b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return true;
        }
        if (prorationEvent.getLong("changereason.id") == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u52a8\u539f\u56e0\uff0c\u5e76\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return true;
        }
        if (prorationEvent.getDate("prorationdate") == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5206\u6bb5\u65e5\u671f\u5fc5\u586b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"ProrationEventValidators_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return true;
        }
        return false;
    }

    private boolean checkIsCanModify(Map<Long, DynamicObject> dbExistDataMap, ExtendedDataEntity entity) {
        DynamicObject prorationEvent = entity.getDataEntity();
        DynamicObject dbExistObj = dbExistDataMap.get(prorationEvent.getLong("id"));
        if (dbExistObj == null) {
            return true;
        }
        if ("2".equals(dbExistObj.getString("eventstatus"))) {
            String errorMsg = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProrationEventValidators_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return false;
        }
        if ("2".equals(dbExistObj.getString("source"))) {
            String errorMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProrationEventValidators_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return false;
        }
        if ("2".equals(dbExistObj.getString("referencestatus"))) {
            String errorMsg = ResManager.loadKDString((String)"\u5df2\u5f15\u7528\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProrationEventValidators_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return false;
        }
        if (prorationEvent.getLong("salaryfile.id") != dbExistObj.getLong("salaryfile.id")) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProrationEventValidators_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
            return false;
        }
        return true;
    }

    private Map<Long, DynamicObject> getDbExistDataMap(ExtendedDataEntity[] dataEntities) {
        logger.info("getDbExistDataMap start");
        Set idSet = Arrays.asList(dataEntities).stream().map(obj -> obj.getDataEntity().getLong("id")).collect(Collectors.toSet());
        String fields = "id,source,eventstatus,referencestatus,salaryfile.id";
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection data = ProrationEventUtils.getProrationEventData((QFilter)filter, (String)fields);
        logger.info("getDbExistDataMap end");
        return data.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
    }

    private Map<Long, DynamicObject> getProrationGenRuleData(Set<Long> genRuleIdSet, Map<Long, Map<Long, DynamicObject>> genRuleEntryMap, Map<Long, Long> hasPermsFileMap) {
        logger.info("getProrationGenRuleData begin");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationgenrule");
        String fields = "id,country,useorg,entryentity,changereason,prorationtype,prorationitem";
        QFilter filter = new QFilter("id", "in", genRuleIdSet);
        List orgIdList = hasPermsFileMap.values().stream().collect(Collectors.toList());
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter qFilter = baseDataService.getBaseDataFilter("hsas_prorationgenrule", orgIdList, true);
        filter.and(qFilter);
        DynamicObject[] result = helper.query(fields, new QFilter[]{filter});
        HashMap<Long, DynamicObject> genRuleMap = new HashMap<Long, DynamicObject>(result.length);
        HashMap<Long, DynamicObject> tempMap = null;
        DynamicObjectCollection entryList = null;
        for (DynamicObject genRule : result) {
            genRuleMap.put(genRule.getLong("id"), genRule);
            entryList = genRule.getDynamicObjectCollection("entryentity");
            if (entryList == null) continue;
            tempMap = new HashMap<Long, DynamicObject>(entryList.size());
            genRuleEntryMap.put(genRule.getLong("id"), tempMap);
            for (DynamicObject entry : entryList) {
                tempMap.put(entry.getLong("changereason.id"), entry);
            }
        }
        logger.info("getProrationGenRuleData end");
        return genRuleMap;
    }

    private boolean checkProrationDate(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        Date firstBsed = data.getDate("salaryfile.firstbsed");
        Date prorationDate = data.getDate("prorationdate");
        if (firstBsed == null || prorationDate == null) {
            return true;
        }
        if (SWCDateTimeUtils.dayBefore((Date)prorationDate, (Date)firstBsed)) {
            String errorMsg = ResManager.loadKDString((String)"%s\u7684\u5206\u6bb5\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"ProrationEventValidators_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, data.getString("salaryfile.employee.showname")));
            return false;
        }
        return true;
    }
}

