/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.prorationrule;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class ProrationRuleSaveValidator
extends SWCDataBaseValidator {
    private static final String NUMERATORFORMULA = "numerator";
    private static final String DENOMINATORFORMULA = "denominator";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey) || SWCStringUtils.equals((String)"submit", (String)operateKey) || SWCStringUtils.equals((String)"confirmchange", (String)operateKey) || SWCStringUtils.equals((String)"confirmchangenoaudit", (String)operateKey)) {
            this.checkData();
        }
    }

    private void checkData() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> formulaIdSet = new HashSet<Long>(dataEntities.length * 2);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject numerator = data.getDynamicObject(NUMERATORFORMULA);
            DynamicObject denominator = data.getDynamicObject(DENOMINATORFORMULA);
            if (numerator != null) {
                formulaIdSet.add(numerator.getLong("id"));
            }
            if (denominator == null) continue;
            formulaIdSet.add(denominator.getLong("id"));
        }
        Map<Long, DynamicObject> searchResult = this.searchFormula(formulaIdSet);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject formula;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject numerator = data.getDynamicObject(NUMERATORFORMULA);
            DynamicObject denominator = data.getDynamicObject(DENOMINATORFORMULA);
            if (numerator != null) {
                formula = searchResult.get(numerator.getLong("id"));
                this.checkFormula(dataEntity, formula, false);
            }
            if (denominator != null) {
                formula = searchResult.get(denominator.getLong("id"));
                this.checkFormula(dataEntity, formula, true);
            }
            this.checkAreaTypeAndCountry(dataEntity);
        }
    }

    private void checkFormula(ExtendedDataEntity dataEntity, DynamicObject formula, boolean isDenominator) {
        long curDataCountryId;
        long countryId;
        if (formula == null) {
            return;
        }
        String areaType = formula.getString("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)"2") && (countryId = formula.getLong("country.id")) != (curDataCountryId = dataEntity.getDataEntity().getLong("country.id"))) {
            String failMsg = isDenominator ? ResManager.loadKDString((String)"\u5206\u6bcd\u516c\u5f0f\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u5b50\u516c\u5f0f\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, failMsg);
            return;
        }
        String status = formula.getString("status");
        String enable = formula.getString("enable");
        if (!SWCStringUtils.equals((String)status, (String)"C") || !SWCStringUtils.equals((String)enable, (String)"1")) {
            String failMsg = isDenominator ? ResManager.loadKDString((String)"\u5206\u6bcd\u516c\u5f0f\u7684\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u5b50\u516c\u5f0f\u7684\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, failMsg);
            return;
        }
        String useType = formula.getString("usetype");
        if (!SWCStringUtils.equals((String)useType, (String)"1")) {
            String failMsg = isDenominator ? ResManager.loadKDString((String)"\u5206\u6bcd\u516c\u5f0f\u7684\u516c\u5f0f\u7528\u9014\u4e0d\u4e3a\u201c\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u5b50\u516c\u5f0f\u7684\u516c\u5f0f\u7528\u9014\u4e0d\u4e3a\u201c\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, failMsg);
            return;
        }
        Date firstBsed = formula.getDate("firstbsed");
        Date bsed = dataEntity.getDataEntity().getDate("bsed");
        if (firstBsed != null && bsed != null && firstBsed.after(bsed)) {
            String failMsg = isDenominator ? ResManager.loadKDString((String)"\u5206\u6bcd\u516c\u5f0f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u5927\u4e8e\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u5f53\u524d\u751f\u6548\u65e5\u671f\uff0c\u8fd8\u672a\u751f\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u5b50\u516c\u5f0f\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u5927\u4e8e\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u5f53\u524d\u751f\u6548\u65e5\u671f\uff0c\u8fd8\u672a\u751f\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationRuleSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, failMsg);
        }
    }

    private Map<Long, DynamicObject> searchFormula(Set<Long> formulaIdSet) {
        if (CollectionUtils.isEmpty(formulaIdSet)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_formula");
        QFilter[] filters = new QFilter[]{BaseDataHisHelper.getHisCurrFilter()};
        DynamicObjectCollection formulas = helper.queryOriginalCollection("id,useorg.id,status,enable,usetype,firstbsed,areatype,country.id", filters);
        return formulas.stream().collect(Collectors.toMap(formula -> formula.getLong("id"), formula -> formula));
    }

    private void checkAreaTypeAndCountry(ExtendedDataEntity dataEntity) {
        DynamicObject obj = dataEntity.getDataEntity();
        String areatype = obj.getString("areatype");
        long countryId = obj.getLong("country.id");
        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"ProrationRuleSaveValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        if (SWCStringUtils.isEmpty((String)areatype)) {
            this.addErrorMessage(dataEntity, errorMsg);
        } else if (SWCStringUtils.equals((String)"2", (String)areatype) && 0L == countryId) {
            this.addErrorMessage(dataEntity, errorMsg);
        } else if (SWCStringUtils.equals((String)"1", (String)areatype) && 0L != countryId) {
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

