/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.file.SalaryFilePermissionHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class AbstractSalaryFileImportSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(AbstractSalaryFileImportSaveValidator.class);
    protected static final Long MONTY_TYPR_ID = 1020L;
    protected static final int MAX_LENGTH = 13;
    protected static final String YEARTYPE = "0";
    protected static final String PAYTYPE = "1";
    protected static final String SALARYFILE = "salaryfile";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String SALARYITEM = "salaryitem";
    protected static final String ORGID = "org.id";
    protected static final String ADMINORGID = "adminorg.id";
    protected static final String EMPGROUPID = "empgroup.id";
    protected static final String PAYROLLGROUPID = "payrollgroup.id";
    protected static final String DESCRIPTION = "description";
    protected Set<Long> importPermissionEmpGroupIdList = new HashSet<Long>();
    protected Set<Long> payRollGroupIdsByPermissionIdList = new HashSet<Long>();
    protected Set<Long> countrySetByPermItemList = new HashSet<Long>();
    protected HasPermOrgResult hasPermOrgResult;
    protected Map<String, DynamicObject> salaryItemMap;
    protected Set<Long> payrollGroupIdSet;
    protected Map<String, Long> payrollGroupIdMap;
    protected Map<Long, String> fileNumberPersonIdMap;

    public void initialize() {
        this.salaryItemMap = this.initSalaryItemMap();
        this.hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"/UHMBBGZQ65X", (String)this.getEntityKey());
        long userId = RequestContext.get().getCurrUserId();
        this.importPermissionEmpGroupIdList = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((Long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"4730fc9f000003ae");
        this.payRollGroupIdsByPermissionIdList = SalaryFilePermissionHelper.getPayRollGroupIdsByPermissionId((String)"4715a0df000000ac");
        this.countrySetByPermItemList = SalaryFilePermissionHelper.getCountrySetByPermItem((String)"4715a0df000000ac");
    }

    protected void verifyPermOrgs(ExtendedDataEntity[] dataEntities) {
        this.payrollGroupIdSet = new HashSet<Long>(16);
        this.payrollGroupIdMap = new HashMap<String, Long>(16);
        this.fileNumberPersonIdMap = new HashMap<Long, String>(16);
        List resultFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"4730fc9f000003ae");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject salaryFileDyObj = dataEntity.getDynamicObject(SALARYFILE);
            if (salaryFileDyObj == null) {
                String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"AbstractSalaryFileImportSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                continue;
            }
            String salaryFileStatus = salaryFileDyObj.getString("status");
            String salaryFileNumber = salaryFileDyObj.getString("number");
            if ("E".equals(salaryFileStatus)) {
                String errorMsg = ResManager.loadKDString((String)"\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u5bfc\u5165\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"AbstractSalaryFileImportSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            } else if ("B".equals(salaryFileStatus)) {
                String errorMsg = ResManager.loadKDString((String)"\u6863\u6848\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5bfc\u5165\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"AbstractSalaryFileImportSaveValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
            long orgId = salaryFileDyObj.getLong(ORGID);
            long adminorgId = salaryFileDyObj.getLong(ADMINORGID);
            long empGroupId = salaryFileDyObj.getLong(EMPGROUPID);
            long countryId = salaryFileDyObj.getLong("payrollregion.id");
            Long payRollGroupId = salaryFileDyObj.getLong(PAYROLLGROUPID);
            if (this.hasPermOrgResult == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                return;
            }
            boolean isAllUser = this.hasPermOrgResult.hasAllOrgPerm();
            if (!isAllUser) {
                String errorMsg;
                HashSet hasPermOrgSets;
                ArrayList hasPermOrgs;
                String errorMsg2;
                if (resultFilter == null) {
                    errorMsg2 = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                }
                if (this.importPermissionEmpGroupIdList != null && !this.importPermissionEmpGroupIdList.contains(empGroupId)) {
                    errorMsg2 = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                }
                if ((hasPermOrgs = this.hasPermOrgResult.getHasPermOrgs()) == null) {
                    hasPermOrgs = new ArrayList();
                }
                if (!(hasPermOrgSets = new HashSet(hasPermOrgs)).contains(orgId)) {
                    errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                }
                if (this.countrySetByPermItemList != null && !this.countrySetByPermItemList.contains(countryId)) {
                    errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                }
                if (this.payRollGroupIdsByPermissionIdList != null && !this.payRollGroupIdsByPermissionIdList.contains(payRollGroupId)) {
                    errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"AbstractSalaryFileImportSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                }
            }
            Long payrollgroupId = salaryFileDyObj.getLong(PAYROLLGROUPID);
            Long personId = salaryFileDyObj.getLong("person.id");
            this.payrollGroupIdSet.add(payrollgroupId);
            this.payrollGroupIdMap.put(salaryFileNumber, payrollgroupId);
            this.fileNumberPersonIdMap.put(personId, salaryFileNumber);
            String description = dataEntity.getString(DESCRIPTION);
            if (!SWCStringUtils.isNotEmpty((String)description) || description.length() <= 255) continue;
            String errorMsg = ResManager.loadKDString((String)"\u201c\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u4e86255\u5b57\u7b26\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"AbstractSalaryFileImportSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private Map<String, DynamicObject> initSalaryItemMap() {
        DynamicObject[] personals;
        HashMap<String, DynamicObject> salaryItemResultMap = new HashMap<String, DynamicObject>();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("datatype.id", "=", (Object)MONTY_TYPR_ID);
        filter.and("status", "=", (Object)"C");
        for (DynamicObject dynamicObject : personals = helper.query("number,ispayoutitem,isfixeditem,enable,status", new QFilter[]{filter})) {
            String salaryfileid = dynamicObject.getString("number");
            if (salaryItemResultMap.containsKey(salaryfileid)) continue;
            salaryItemResultMap.put(salaryfileid, dynamicObject);
        }
        return salaryItemResultMap;
    }
}

