/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.common.dto.DateTimeRangeEntity;
import kd.swc.hsas.common.dto.MultiDateTimeRangeEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class EmpPosOrgRelSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet<Long> depEmpIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> salaryFileIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity datas : dataEntities) {
            DynamicObject dataEntity = datas.getDataEntity();
            this.processEntryEntity(dataEntity);
            salaryFileIds.add(dataEntity.getLong("salaryfile.id"));
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            HashMap<Long, Map<String, Object>> workRoleDateRange = new HashMap<Long, Map<String, Object>>(dynamicObjectCollection.size());
            for (DynamicObject entry : dynamicObjectCollection) {
                long workRoleId = entry.getLong("workrole.id");
                if (workRoleId == 0L) continue;
                depEmpIds.add(workRoleId);
                Map workRoleData = workRoleDateRange.computeIfAbsent(workRoleId, key -> new HashMap(16));
                workRoleData.putIfAbsent("workRoleName", entry.getString("workrole.showname"));
                workRoleData.putIfAbsent("workRoleNumber", entry.getString("workrole.number"));
                MultiDateTimeRangeEntity dateTimeRange = (MultiDateTimeRangeEntity)workRoleData.computeIfAbsent("dateTimeRange", key -> new MultiDateTimeRangeEntity());
                Date payStartDate = entry.getDate("paystartdate");
                Date payEndDate = entry.getDate("payenddate");
                if (payStartDate == null || payEndDate == null) continue;
                dateTimeRange.add(payStartDate, payEndDate);
            }
            this.validateWorkRoleDateRange(datas, workRoleDateRange);
        }
        List empPosOrgRelByDepEmps = SalaryFileEmpPosOrgRelHelper.getEmpPosOrgRelByDepEmpId(depEmpIds);
        Map workRoleDateMap = SalaryFileEmpPosOrgRelHelper.getEmpDepDateMap((List)empPosOrgRelByDepEmps, depEmpIds);
        this.validateSave(dataEntities, workRoleDateMap);
        Map<Long, Map<Long, Map<String, Object>>> salaryDepEmpDateRange = this.getSalaryDepEmpDateRange(salaryFileIds);
        if (CollectionUtils.isEmpty(salaryDepEmpDateRange)) {
            return;
        }
        this.validatePayEndData(dataEntities, salaryDepEmpDateRange);
    }

    private void validateWorkRoleDateRange(ExtendedDataEntity dataEntity, Map<Long, Map<String, Object>> workRoleDateRange) {
        if (CollectionUtils.isEmpty(workRoleDateRange)) {
            return;
        }
        workRoleDateRange.forEach((workRoleId, workRoleData) -> {
            String workRoleName = (String)workRoleData.get("workRoleName");
            String workRoleNumber = (String)workRoleData.get("workRoleNumber");
            MultiDateTimeRangeEntity dateTimeRange = (MultiDateTimeRangeEntity)workRoleData.get("dateTimeRange");
            if (dateTimeRange.isIntersect()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u5c97\u4f4d\u5728\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u4e2d\u5b58\u5728\u591a\u884c\u4e14\u7b97\u85aa\u5f00\u59cb\u7ed3\u675f\u65e5\u671f\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"EmpPosOrgRelSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber}));
            }
        });
    }

    private void processEntryEntity(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            Date payEndDate = dynamicObject.getDate("payenddate");
            if (payEndDate != null) continue;
            dynamicObject.set("payenddate", (Object)SalaryFileEmpPosOrgRelHelper.getMaxDate());
        }
    }

    private void validatePayEndData(ExtendedDataEntity[] dataEntities, Map<Long, Map<Long, Map<String, Object>>> salaryDateRangeMap) {
        if (dataEntities == null || dataEntities.length == 0 || CollectionUtils.isEmpty(salaryDateRangeMap)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            long salaryFileId = data.getLong("salaryfile.id");
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entryentity");
            HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
            HashMap<Long, MultiDateTimeRangeEntity> tempDateTimeRange = new HashMap<Long, MultiDateTimeRangeEntity>(16);
            for (DynamicObject entry : dynamicObjectCollection) {
                boolean isMainWorkRole = entry.getBoolean("ismainworkrole");
                if (!isMainWorkRole) continue;
                long workRoleId2 = entry.getLong("workrole.id");
                String workRoleNumber = entry.getString("workrole.number");
                idNumberMap.putIfAbsent(workRoleId2, workRoleNumber);
                MultiDateTimeRangeEntity dateTimeRange = tempDateTimeRange.computeIfAbsent(workRoleId2, item -> new MultiDateTimeRangeEntity());
                dateTimeRange.add(new DateTimeRangeEntity(entry.getDate("paystartdate"), entry.getDate("payenddate")));
            }
            Map<Long, Map<String, Object>> dateTimeRangeMap = salaryDateRangeMap.get(salaryFileId);
            if (CollectionUtils.isEmpty(dateTimeRangeMap)) continue;
            dateTimeRangeMap.forEach((workRoleId, depEmpDataMap) -> {
                if (CollectionUtils.isEmpty((Map)depEmpDataMap)) {
                    return;
                }
                String workRoleNumber = (String)depEmpDataMap.get("workRoleNumber");
                MultiDateTimeRangeEntity dateTimeRangeEntity = (MultiDateTimeRangeEntity)depEmpDataMap.get("dateTimeRange");
                MultiDateTimeRangeEntity stopDateTimeRangeEntity = (MultiDateTimeRangeEntity)depEmpDataMap.get("stopPayDateTimeRange");
                MultiDateTimeRangeEntity subDateTimeRange = (MultiDateTimeRangeEntity)tempDateTimeRange.get(workRoleId);
                String separator = ResManager.loadKDString((String)"\u201d\u3001\u201c", (String)"EmpPosOrgRelSaveValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                String zhi = ResManager.loadKDString((String)"\u81f3", (String)"EmpPosOrgRelSaveValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                if (subDateTimeRange == null) {
                    if (CollectionUtils.isEmpty((Collection)dateTimeRangeEntity.getRangeEntities())) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u5c97\u4f4d\u4e3a\u85aa\u8d44\u6863\u6848\u57fa\u7840\u4fe1\u606f\u7684\u4e3b\u8981\u5c97\u4f4d\uff0c\u9700\u8981\u6dfb\u52a0\u5230\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u3002", (String)"EmpPosOrgRelSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber}));
                    } else {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u4e3b\u8981\u5c97\u4f4d\u5728\u201c{1}\u201d\u4e3a\u6b63\u5e38\u7b97\u85aa\uff0c\u9700\u8981\u6dfb\u52a0\u5230\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u4e2d\u3002", (String)"EmpPosOrgRelSaveValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber, dateTimeRangeEntity.getRangeEntities().stream().sorted(DateTimeRangeEntity::compareTo).map(item -> SWCDateTimeUtils.formatDate((Date)item.getStartDate()) + zhi + SWCDateTimeUtils.formatDate((Date)item.getEndDate())).collect(Collectors.joining(separator))}));
                    }
                } else if (!subDateTimeRange.mergeAdjacent().isCovered(dateTimeRangeEntity)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u4e3b\u8981\u5c97\u4f4d\u5728\u201c{1}\u201d\u4e3a\u6b63\u5e38\u7b97\u85aa\uff0c\u4e0d\u5141\u8bb8\u7b97\u85aa\u7ed3\u675f\uff0c\u8bf7\u4fee\u6539\u7b97\u85aa\u5f00\u59cb/\u7ed3\u675f\u65e5\u671f\u540e\u518d\u8bd5\u3002", (String)"EmpPosOrgRelSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber, dateTimeRangeEntity.getRangeEntities().stream().sorted(DateTimeRangeEntity::compareTo).map(item -> SWCDateTimeUtils.formatDate((Date)item.getStartDate()) + zhi + SWCDateTimeUtils.formatDate((Date)item.getEndDate())).collect(Collectors.joining(separator))}));
                }
            });
        }
    }

    private String getKey(long salaryFileId, long workRoleId) {
        return salaryFileId + "#" + workRoleId;
    }

    private Map<Long, Map<Long, Map<String, Object>>> getSalaryDepEmpDateRange(Set<Long> salaryFileIds) {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter("boid", "in", salaryFileIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        DynamicObject[] querySalaryFiles = swcDataServiceHelper.query("id,number,depemp,bsed,bsled,boid,paystatus", new QFilter[]{salaryFileFilter, dataStatusFilter});
        if (querySalaryFiles == null || querySalaryFiles.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<Long, Map<String, Object>>> result = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        HashSet<String> conflictDate = new HashSet<String>(16);
        for (DynamicObject querySalaryFile : querySalaryFiles) {
            MultiDateTimeRangeEntity dateTimeRangeEntity;
            long depEmpId = querySalaryFile.getLong("depemp.id");
            long salaryFileBoId = querySalaryFile.getLong("boid");
            if (depEmpId == 0L || salaryFileBoId == 0L) continue;
            Date bsed = querySalaryFile.getDate("bsed");
            Date bsled = querySalaryFile.getDate("bsled");
            String uniqueKey = salaryFileBoId + "-" + bsed.getTime() + "-" + bsled.getTime();
            if (!conflictDate.add(uniqueKey)) continue;
            Map dateTimeRange = result.computeIfAbsent(salaryFileBoId, item -> new HashMap(16));
            Map depEmpDataMap = dateTimeRange.computeIfAbsent(depEmpId, item -> new HashMap(16));
            depEmpDataMap.putIfAbsent("workRoleName", querySalaryFile.getString("depemp.showname"));
            depEmpDataMap.putIfAbsent("workRoleNumber", querySalaryFile.getString("depemp.number"));
            String payStatus = querySalaryFile.getString("paystatus");
            if ("1".equals(payStatus)) {
                dateTimeRangeEntity = (MultiDateTimeRangeEntity)depEmpDataMap.computeIfAbsent("dateTimeRange", item -> new MultiDateTimeRangeEntity());
                dateTimeRangeEntity.add(bsed, bsled);
            } else {
                dateTimeRangeEntity = (MultiDateTimeRangeEntity)depEmpDataMap.computeIfAbsent("stopPayDateTimeRange", item -> new MultiDateTimeRangeEntity());
                dateTimeRangeEntity.add(bsed, bsled);
            }
            depEmpDataMap.computeIfAbsent("dateTimeRange", item -> new MultiDateTimeRangeEntity());
            depEmpDataMap.computeIfAbsent("stopPayDateTimeRange", item -> new MultiDateTimeRangeEntity());
        }
        return result;
    }

    private void validateSave(ExtendedDataEntity[] dataEntities, Map<Long, List<Map<String, Object>>> empPosOrgRelByDepEmps) {
        OperateOption option = this.getOption();
        RefObject ref = new RefObject();
        option.tryGetVariableValue("isValidate", ref);
        Boolean isValidate = !"false".equals(ref.getValue());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (isValidate.booleanValue()) {
                    this.validateDate(dataEntity, dynamicObject);
                }
                this.validateOverlapDate(dataEntity, dynamicObject, empPosOrgRelByDepEmps.get(dynamicObject.getLong("workrole.id")));
            }
        }
    }

    private void validateOverlapDate(ExtendedDataEntity dataEntity, DynamicObject object, List<Map<String, Object>> maps) {
        if (CollectionUtils.isEmpty(maps) || !SalaryFileEmpPosOrgRelHelper.isValidateDepEmpDateForFronted()) {
            return;
        }
        DynamicObject data = dataEntity.getDataEntity();
        String number = data.getString("salaryfile.number");
        Long salaryfileId = data.getLong("salaryfile.id");
        long workRoleId = object.getLong("workrole.id");
        String workRoleNumber = object.getString("workrole.number");
        Date newPayStartDate = object.getDate("paystartdate");
        Date newPayEndDate = object.getDate("payenddate");
        for (Map<String, Object> dataMap : maps) {
            boolean condition;
            Long otherSalaryFileId = (Long)dataMap.get("salaryFileId");
            if (salaryfileId.equals(otherSalaryFileId)) continue;
            Date payStartDate = (Date)dataMap.get("payStartDate");
            Date payEndDate = (Date)dataMap.get("payEndDate");
            String otherSalaryFileNumber = (String)dataMap.get("salaryFileNumber");
            Date date = payEndDate = payStartDate == null ? SalaryFileEmpPosOrgRelHelper.getMaxDate() : payEndDate;
            if (newPayStartDate == null || newPayEndDate == null || payStartDate == null || (condition = newPayStartDate.before(payStartDate) && newPayEndDate.before(payStartDate) || newPayStartDate.after(payEndDate) && newPayEndDate.after(payEndDate))) continue;
            String payStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_empposorgrel", (String)"paystartdate", (Date)payStartDate);
            String payEndDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_empposorgrel", (String)"payenddate", (Date)payEndDate);
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u6240\u9009\u62e9\u7684\u5c97\u4f4d\u5728\u201c{1}~{2}\u201d\u5df2\u88ab\u5173\u8054\u5230\u85aa\u8d44\u6863\u6848 {3}\uff0c\u4e0d\u5141\u8bb8\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"EmpPosOrgRelSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber, payStartDateStr, payEndDateStr, otherSalaryFileNumber}));
        }
    }

    private void validateDate(ExtendedDataEntity dataEntity, DynamicObject entry) {
        DynamicObject empPosOrgRel = dataEntity.getDataEntity();
        Date payStartDate = entry.getDate("paystartdate");
        payStartDate = payStartDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)payStartDate) : null;
        Date payEndDate = entry.getDate("payenddate");
        payEndDate = payEndDate == null ? SalaryFileEmpPosOrgRelHelper.getMaxDate() : SalaryFileEmpPosOrgRelHelper.getDateDay((Date)payEndDate);
        Date startDate = entry.getDate("workrole.startdate");
        startDate = startDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)startDate) : null;
        Date endDate = entry.getDate("workrole.enddate");
        endDate = endDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)endDate) : null;
        Date firstbsed = empPosOrgRel.getDate("salaryfile.firstbsed");
        firstbsed = firstbsed != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)firstbsed) : null;
        String workRoleNumber = entry.getString("workrole.number");
        if (payStartDate != null && payEndDate != null && payStartDate.after(payEndDate)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber}));
        }
        if (payEndDate != null && startDate != null && payEndDate.before(startDate)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber}));
        }
        if (payStartDate != null && firstbsed != null && payStartDate.before(firstbsed)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u85aa\u8d44\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber}));
        }
    }
}

