/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryFileCommonValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> personIdList = new ArrayList<Long>();
        ArrayList<Long> depempIdList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            personIdList.add(dataEntity.getDataEntity().getLong("person.id"));
            depempIdList.add(dataEntity.getDataEntity().getLong("depemp.id"));
        }
        this.validatePersonHr(dataEntities, personIdList);
        this.validateEmpPosOrg(dataEntities, depempIdList);
    }

    private void validatePersonHr(ExtendedDataEntity[] dataEntities, List<Long> personIdList) {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_personhr");
        QFilter idFilter = new QFilter("id", "in", personIdList);
        idFilter.and("datastatus", "=", (Object)"-1");
        DynamicObject[] personObjs = personHelper.query(new QFilter[]{idFilter});
        Set abandonPersonIds = Arrays.stream(personObjs).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5165\u804c\u5df2\u88ab\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8{2}\u6863\u6848\u3002", (String)"SalaryFileCommonValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        String opName = this.getOperationName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject fileDy = dataEntity.getDataEntity();
            Long personId = fileDy.getLong("person.id");
            if (!abandonPersonIds.contains(personId)) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(msg, fileDy.getString("person.name"), fileDy.getString("person.number"), opName));
        }
    }

    private void validateEmpPosOrg(ExtendedDataEntity[] dataEntities, List<Long> depEmpIds) {
        SWCDataServiceHelper empPosOrgRelHr = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter depEmpIdFilter = new QFilter("depemp.id", "in", depEmpIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)depEmpIdFilter);
        DynamicObject[] empPosOrgs = empPosOrgRelHr.query("depemp.id, datastatus", new QFilter[]{depEmpIdFilter});
        Map<Long, String> empMap = Arrays.stream(empPosOrgs).collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy.getString("datastatus"), (k1, k2) -> k1));
        String msg = "import_save".equals(this.getOperateKey()) ? ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u4e1a\u52a1\u7f16\u7801\u5bf9\u5e94\u4efb\u804c\u5df2\u5e9f\u5f03\u3002", (String)"SalaryFileCommonValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6863\u6848\u4e3b\u8981\u5c97\u4f4d\u5df2\u5e9f\u5f03\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SalaryFileCommonValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject salaryFile = dataEntity.getDataEntity();
            if (!"-1".equals(empMap.get(salaryFile.getLong("depemp.id")))) continue;
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }
}

