/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class SalaryFileImportSaveValidator
extends SWCDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileImportSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateSalaryFileImportCert(dataEntities);
    }

    private void validateSalaryFileImportCert(ExtendedDataEntity[] dataEntities) {
        ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!"C".equals(data.getString("status"))) continue;
            files.add(data);
        }
        if (files.isEmpty()) {
            return;
        }
        try {
            Map veryfiResult = PersonCertCommonHelper.verifyCert(files);
            Set failList = (Set)veryfiResult.get("failList");
            String message = (String)veryfiResult.get("message");
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                if (!failList.contains(pid)) continue;
                LOGGER.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
    }
}

