/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile.paysetting;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySettingImportDataValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> employeeIdList = new HashSet<Long>(16);
        HashSet<Long> payRollGroupIdList = new HashSet<Long>(16);
        HashBasedTable orgCountryTable = HashBasedTable.create();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            this.addIdToList(employeeIdList, extendedDataEntity, "salaryfile.employee.id");
            this.addIdToList(payRollGroupIdList, extendedDataEntity, "salaryfile.payrollgroup.id");
            this.queryPaySubjectBySalaryFile((HashBasedTable<Long, Long, Set<Long>>)orgCountryTable, extendedDataEntity);
            this.validatePaySettingEntry(extendedDataEntity);
        }
        orgCountryTable.clear();
        this.validatePersonBankCardNumber(dataEntities);
        Map payRollGroupAndItemMap = PaySalarySettingHelper.getPayRollGroupAndItemMap(payRollGroupIdList);
        this.validateImportSalaryItem(dataEntities, payRollGroupAndItemMap);
    }

    private void addIdToList(Set<Long> idSet, ExtendedDataEntity extendedDataEntity, String idKey) {
        DynamicObject paySettingImportDy = extendedDataEntity.getDataEntity();
        long id = paySettingImportDy.getLong(idKey);
        idSet.add(id);
    }

    private void queryPaySubjectBySalaryFile(HashBasedTable<Long, Long, Set<Long>> orgCountryTable, ExtendedDataEntity extendedDataEntity) {
        Long countryId;
        DynamicObject paySettingImportDy = extendedDataEntity.getDataEntity();
        DynamicObject salaryFile = paySettingImportDy.getDynamicObject("salaryfile");
        Long orgId = salaryFile.getLong("org.id");
        Set paySubjectSet = (Set)orgCountryTable.get((Object)orgId, (Object)(countryId = Long.valueOf(salaryFile.getLong("payrollregion.id"))));
        if (paySubjectSet == null) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
            QFilter filter = new QFilter("country.id", "=", (Object)countryId);
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_paysubject", (Long)orgId));
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection paySubjectCol = helper.queryOriginalCollection("id", new QFilter[]{filter, statusFilter, enableFilter});
            paySubjectSet = paySubjectCol.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
            orgCountryTable.put((Object)orgId, (Object)countryId, paySubjectSet);
        }
        this.validateSalaryFilePaySubject(extendedDataEntity, paySubjectSet);
    }

    private void validateSalaryFilePaySubject(ExtendedDataEntity dataEntity, Set<Long> idSet) {
        DynamicObject paySettingImportDy = dataEntity.getDataEntity();
        DynamicObjectCollection entryCollection = paySettingImportDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCollection) {
            Long paySubjectId = entry.getLong("paysubject.id");
            if (idSet.contains(paySubjectId)) continue;
            String paySubjectNumber = entry.getString("paysubject.number");
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(\u652f\u4ed8\u4e3b\u4f53)\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a\u201c%s\u201d\u3002", (String)"PaySettingImportDataValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]), paySubjectNumber));
        }
    }

    private void validatePaySettingEntry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject paySettingImportDy = extendedDataEntity.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = paySettingImportDy.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection.isEmpty()) {
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaySettingImportDataValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject paySettingImportEntryDy : dynamicObjectCollection) {
            this.validatePaymentWay(extendedDataEntity, paySettingImportEntryDy);
            this.validatePayType(extendedDataEntity, paySettingImportEntryDy);
            this.validateSalaryItemType(extendedDataEntity, paySettingImportEntryDy);
        }
    }

    private void validateSalaryItemType(ExtendedDataEntity extendedDataEntity, DynamicObject paySettingImportEntryDy) {
        Long salaryItemId;
        String salaryItemMark = paySettingImportEntryDy.getString("salaryitemmark");
        if (("0".equals(salaryItemMark) || "2".equals(salaryItemMark)) && (salaryItemId = Long.valueOf(paySettingImportEntryDy.getLong("salaryitem.id"))) != 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u5b9e\u53d1\u9879\u76ee\u4e3a\u201c\u5176\u4ed6\u201d\u6216\u201c\u5168\u90e8\u201d\u65f6\uff0c\u65e0\u9700\u586b\u5199\u201c\u6307\u5b9a\u5b9e\u53d1\u9879\u76ee\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private void validatePayType(ExtendedDataEntity extendedDataEntity, DynamicObject paySettingImportEntryDy) {
        String bankCardNum;
        String payType = paySettingImportEntryDy.getString("paytype.paycategory.number");
        if (!"1010_S".equals(payType) && !"1020_S".equals(payType) && SWCStringUtils.isNotEmpty((String)(bankCardNum = paySettingImportEntryDy.getString("perbankcard.bankcardnum")))) {
            String errorMsg = ResManager.loadKDString((String)"\u652f\u4ed8\u5f62\u5f0f\u7c7b\u522b\u4e0d\u4e3a\u201c\u94f6\u884c\u8f6c\u8d26\u201d\u6216\u201c\u7535\u6c47\u201d\uff0c\u65e0\u9700\u586b\u5199\u94f6\u884c\u8d26\u53f7\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private void validatePaymentWay(ExtendedDataEntity extendedDataEntity, DynamicObject paySettingImportEntryDy) {
        String paymentWay = paySettingImportEntryDy.getString("paymentway");
        if ("0".equals(paymentWay)) {
            BigDecimal payRate;
            BigDecimal payAmount = paySettingImportEntryDy.getBigDecimal("payamount");
            if (BigDecimal.ZERO.compareTo(payAmount) != 0) {
                String errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u65b9\u5f0f\u4e3a\u201c\u6307\u5b9a\u6bd4\u4f8b\u201d\u65f6\uff0c\u65e0\u9700\u586b\u5199\u201c\u6307\u5b9a\u91d1\u989d\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
            if (BigDecimal.ZERO.compareTo(payRate = paySettingImportEntryDy.getBigDecimal("payrate").stripTrailingZeros()) == 0) {
                String errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u65b9\u5f0f\u4e3a\u201c\u6307\u5b9a\u6bd4\u4f8b\u201d\u65f6\uff0c\u201c\u53d1\u653e\u6bd4\u4f8b\u201d\u5fc5\u586b\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
        } else if ("1".equals(paymentWay)) {
            BigDecimal payAmount;
            BigDecimal payRate = paySettingImportEntryDy.getBigDecimal("payrate");
            if (BigDecimal.ZERO.compareTo(payRate) != 0) {
                String errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u65b9\u5f0f\u4e3a\u201c\u6307\u5b9a\u91d1\u989d\u201d\u65f6\uff0c\u65e0\u9700\u586b\u5199\u201c\u53d1\u653e\u6bd4\u4f8b\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
            if (BigDecimal.ZERO.compareTo(payAmount = paySettingImportEntryDy.getBigDecimal("payamount").stripTrailingZeros()) == 0) {
                String errorMsg = ResManager.loadKDString((String)"\u53d1\u653e\u65b9\u5f0f\u4e3a\u201c\u6307\u5b9a\u91d1\u989d\u201d\u65f6\uff0c\u201c\u53d1\u653e\u91d1\u989d\u201d\u5fc5\u586b\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
        }
    }

    private void validatePersonBankCardNumber(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject paySettingImportDy = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = paySettingImportDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject paySettingImportEntryDy : dynamicObjectCollection) {
                String importBankCardNum;
                String payType = paySettingImportEntryDy.getString("paytype.paycategory.number");
                if (!"1010_S".equals(payType) && !"1020_S".equals(payType) || !SWCStringUtils.isEmpty((String)(importBankCardNum = paySettingImportEntryDy.getString("perbankcard.bankcardnum")))) continue;
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u5361\u8d26\u53f7\u3002", (String)"PaySettingImportDataValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
        }
    }

    private void validateImportSalaryItem(ExtendedDataEntity[] dataEntities, Map<Long, Set<Long>> payRollGroupAndItemMap) {
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject paySettingImportDy = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = paySettingImportDy.getDynamicObjectCollection("entryentity");
            long payrollGroupId = paySettingImportDy.getLong("salaryfile.payrollgroup.id");
            Set<Long> itemList = payRollGroupAndItemMap.get(payrollGroupId);
            for (DynamicObject paySettingImportEntryDy : dynamicObjectCollection) {
                String errorMsg;
                String salaryItemMark = paySettingImportEntryDy.getString("salaryitemmark");
                if (!"1".equals(salaryItemMark)) continue;
                Long salaryItemId = paySettingImportEntryDy.getLong("salaryitem.id");
                if (salaryItemId == 0L) {
                    errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u5b9e\u53d1\u9879\u76ee\u4e3a\u6307\u5b9a\u9879\u76ee\u65f6\uff0c\u6307\u5b9a\u5b9e\u53d1\u9879\u76ee\u7f16\u7801\u5fc5\u586b\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingImportDataValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                    continue;
                }
                if (!CollectionUtils.isEmpty(itemList) && itemList.contains(salaryItemId)) continue;
                errorMsg = ResManager.loadKDString((String)"\u53ea\u53ef\u5bfc\u5165\u6863\u6848\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u4e2d\uff0c\u8ba1\u7b97\u89c4\u5219\u6240\u6709\u7248\u672c\u4e2d\u6807\u8bb0\u4e3a\u201c\u5b9e\u53d1\u201d\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"PaySettingImportDataValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
        }
    }
}

