/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile.paysetting;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingAmountAccuracyValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingBaseValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingEffectiveValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingRateValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingRequiredValidator;

public class PaySettingValidatorService {
    private PaySettingBaseValidator paySettingRequiredValidator;
    private PaySettingBaseValidator paySettingEffectiveValidator;
    private PaySettingBaseValidator paySettingRateValidator;
    private PaySettingBaseValidator paySettingAmountAccuracyValidator;
    private String type;

    public PaySettingValidatorService(String type) {
        this.type = type;
    }

    public void init() {
        if ("importtype".equals(this.type)) {
            this.newCommonValidator();
            this.setImportValidatorALG();
        } else {
            this.paySettingRequiredValidator = new PaySettingRequiredValidator();
            this.newCommonValidator();
            this.setValidatorALG();
        }
    }

    private void newCommonValidator() {
        this.paySettingEffectiveValidator = new PaySettingEffectiveValidator();
        this.paySettingRateValidator = new PaySettingRateValidator();
        this.paySettingAmountAccuracyValidator = new PaySettingAmountAccuracyValidator();
    }

    private void setValidatorALG() {
        this.paySettingRequiredValidator.setNextValidator(this.paySettingEffectiveValidator);
        this.paySettingEffectiveValidator.setNextValidator(this.paySettingRateValidator);
        this.paySettingRateValidator.setNextValidator(this.paySettingAmountAccuracyValidator);
    }

    private void setImportValidatorALG() {
        this.paySettingEffectiveValidator.setNextValidator(this.paySettingRateValidator);
        this.paySettingRateValidator.setNextValidator(this.paySettingAmountAccuracyValidator);
    }

    public List<String> validator(DynamicObject paySetting) {
        return this.paySettingRequiredValidator.validator(paySetting);
    }

    public List<String> importValidator(DynamicObject paySetting) {
        return this.paySettingEffectiveValidator.validator(paySetting);
    }
}

