/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.agencypay;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.opplugin.validator.agencypay.AgencyPaySaveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgencyPaySaveOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(AgencyPaySaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.paydetail");
        fieldKeys.add("payrollgrp.id");
        fieldKeys.add("org.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AgencyPaySaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        boolean isWriteBack;
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String isWriteBackStr = (String)variables.get("iswriteback");
        if (SWCStringUtils.isNotEmpty((String)isWriteBackStr) && !(isWriteBack = Boolean.parseBoolean(isWriteBackStr))) {
            this.log.info("\u672c\u6b21\u4fdd\u5b58\u4ee3\u53d1\u5355\u4e0d\u4f1a\u53cd\u5199");
            return;
        }
        this.log.info("\u672c\u6b21\u4fdd\u5b58\u4ee3\u53d1\u5355\u5c06\u4f1a\u6267\u884c\u53cd\u5199\u4ee3\u7801\u5757\uff0c\u53bb\u53cd\u5199\u6838\u7b97\u4efb\u52a1\u548c\u6838\u7b97\u5217\u8868");
        this.log.info("\u5f00\u59cb\u53cd\u5199\u65f6\u95f4\uff1a{}", (Object)new Date());
        DynamicObject[] entities = args.getDataEntities();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        DynamicObjectCollection updateCols = new DynamicObjectCollection();
        HashSet billIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap detailBillIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject entity : entities) {
            DynamicObjectCollection ents = entity.getDynamicObjectCollection("entryentity");
            long billId = entity.getLong("id");
            this.getPayDetailBillMap(ents, billId, detailBillIdMap);
            billIds.add(billId);
        }
        DynamicObjectCollection allPaydetails = new DynamicObjectCollection();
        HashSet calPersonIdSet = Sets.newHashSetWithExpectedSize((int)16);
        this.queryPayDetail(allPaydetails, calPersonIdSet, billIds, detailBillIdMap.keySet());
        for (DynamicObject paydetail : allPaydetails) {
            long paydetailId = paydetail.getLong("id");
            Long billId = (Long)detailBillIdMap.get(paydetailId);
            if (billId != null) {
                paydetail.set("agencypaybill", (Object)billId);
                paydetail.set("agencypaystate", (Object)AgencyPayStateEnum.GENERATED.getCode());
            } else {
                paydetail.set("agencypaybill", (Object)0L);
                paydetail.set("agencypaystate", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
            }
            updateCols.add((Object)paydetail);
        }
        Object[] payDetailArray = new DynamicObject[updateCols.size()];
        payDetailArray = (DynamicObject[])updateCols.toArray(payDetailArray);
        this.log.info("1\u3001\u53cd\u5199\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)new Date());
        helper.update((DynamicObject[])payDetailArray);
        this.log.info("1\u3001\u53cd\u5199\u660e\u7ec6\u5b8c\u6210\u65f6\u95f4\uff1a{}", (Object)new Date());
        this.log.info("2\u3001\u53cd\u5199\u6838\u7b97\u5927\u8868\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)new Date());
        this.updateCaltablePaystate(calPersonIdSet);
        this.log.info("2\u3001\u53cd\u5199\u6838\u7b97\u5927\u8868\u5b8c\u6210\u65f6\u95f4\uff1a{}", (Object)new Date());
        this.log.info("\u5b8c\u6210\u53cd\u5199\u65f6\u95f4\uff1a{}", (Object)new Date());
    }

    private void updateCaltablePaystate(Set<Long> calPersonIdSet) {
        AgencyPayWriteBackService writeBackService = new AgencyPayWriteBackService();
        writeBackService.updateCaltablePayState(calPersonIdSet);
    }

    private void queryPayDetail(DynamicObjectCollection allPaydetails, Set<Long> calPersonIdSet, Set<Long> billIds, Set<Long> allDetailIds) {
        DynamicObject[] cols;
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("agencypaybill.id", "in", billIds);
        filter.or("id", "in", allDetailIds);
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "id,agencypaybill,agencypaystate,calpersonid";
        for (DynamicObject col : cols = detailHelper.query(selectProperties, filters)) {
            calPersonIdSet.add(col.getLong("calpersonid"));
            allPaydetails.add((Object)col);
        }
    }

    private void getPayDetailBillMap(DynamicObjectCollection ents, Long bill, Map<Long, Long> detailBillIdMap) {
        for (DynamicObject ent : ents) {
            long paydetailId = ent.getLong("paydetail.id");
            detailBillIdMap.put(paydetailId, bill);
        }
    }
}

