/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.agencypay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.opplugin.validator.agencypay.AgencyPaySubmitValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AgencyPaySubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.paydetail");
        fieldKeys.add("auditstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("payrollgrp.id");
        fieldKeys.add("org.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AgencyPaySubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        this.getOption().setVariableValue("pushandsave_showfailrow", "true");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> detailId = new HashSet<Long>(dataEntities.length);
        HashSet<Long> calPersonIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("auditstatus", (Object)"B");
            dataEntity.set("billstatus", (Object)"B");
            detailId.addAll(this.getDetailIds(dataEntity));
            calPersonIdSet.addAll(this.getCalPersonIds(dataEntity));
        }
        new SWCDataServiceHelper("hsas_agencypaybill").update(dataEntities);
        this.updateAndWriteBack(detailId, calPersonIdSet);
    }

    private Set<Long> getCalPersonIds(DynamicObject dataEntity) {
        DynamicObjectCollection ents = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet<Long> calTableIdSet = new HashSet<Long>(ents.size());
        for (DynamicObject ent : ents) {
            calTableIdSet.add(ent.getLong("paydetail.calpersonid"));
        }
        return calTableIdSet;
    }

    private List<Long> getDetailIds(DynamicObject dataEntity) {
        DynamicObjectCollection ents = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Long> ids = new ArrayList<Long>(ents.size());
        for (DynamicObject ent : ents) {
            ids.add(ent.getLong("paydetail.id"));
        }
        return ids;
    }

    private void updateAndWriteBack(Set<Long> detailId, Set<Long> calTableIdSet) {
        AgencyPayWriteBackService service = new AgencyPayWriteBackService();
        service.submitCasWriteBackDetail(detailId);
        service.updateCaltablePayState(calTableIdSet);
    }
}

