/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.agencypay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.agencypay.AgencyPayMService;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.opplugin.validator.agencypay.AgencyPayUnSubmitValidator;

public class AgencyPayUnSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("auditstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("entryentity.paydetail");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AgencyPayUnSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<String> billIds = new ArrayList<String>(dataEntities.length);
        HashSet<Long> detailId = new HashSet<Long>(dataEntities.length);
        HashSet<Long> calTableIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            billIds.add(dataEntity.getString("id"));
            detailId.addAll(this.getDetailIds(dataEntity));
            calTableIdSet.addAll(this.getCaltablIds(dataEntity));
        }
        AgencyPayMService.unSubmitCas(billIds);
        this.updateAndWriteBack(detailId, calTableIdSet);
    }

    private Set<Long> getCaltablIds(DynamicObject dataEntity) {
        DynamicObjectCollection ents = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet<Long> calTableIdSet = new HashSet<Long>(ents.size());
        for (DynamicObject ent : ents) {
            calTableIdSet.add(ent.getLong("paydetail.calpersonid"));
        }
        return calTableIdSet;
    }

    private List<Long> getDetailIds(DynamicObject dataEntity) {
        DynamicObjectCollection ents = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Long> ids = new ArrayList<Long>(ents.size());
        for (DynamicObject ent : ents) {
            ids.add(ent.getLong("paydetail.id"));
        }
        return ids;
    }

    private void updateAndWriteBack(Set<Long> detailId, Set<Long> calTableIdSet) {
        AgencyPayWriteBackService service = new AgencyPayWriteBackService();
        service.unSubmitCasWriteBackDetail(detailId);
        service.updateCaltablePayState(calTableIdSet);
    }
}

