/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.agencypay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.swc.hsas.business.agencypay.AgencyPayHelper;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.opplugin.validator.agencypay.PaydetailCreateBillValitor;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaydetailCreateBillOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(PaydetailCreateBillOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("paycurrency.id");
        fieldKeys.add("org.id");
        fieldKeys.add("paysubjecthis");
        fieldKeys.add("agentpayorg.id");
        fieldKeys.add("paystate");
        fieldKeys.add("agencypaystate");
        fieldKeys.add("agencypaybill");
        fieldKeys.add("caltableid");
        fieldKeys.add("calpersonid");
        fieldKeys.add("ismustbankcard");
        fieldKeys.add("salaryfilehis.number");
        fieldKeys.add("salaryfilehis.person.name");
        fieldKeys.add("salaryfilehis.person.number");
        fieldKeys.add("calperiod");
        fieldKeys.add("salaryitem.name");
        fieldKeys.add("onholdstatus");
        fieldKeys.add("abandonedstatus");
        fieldKeys.add("empgroup.id");
        fieldKeys.add("caltask.payrollgroup.id");
        fieldKeys.add("perbankcard");
        fieldKeys.add("paytype");
        fieldKeys.add("acctmodifybill");
        fieldKeys.add("bankofferstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PaydetailCreateBillValitor());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String isSplitCurStr;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_agencypaybill");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_agencypaybill");
        EntityType entType = this.getAgencyBillEntDataType(mainType);
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hsas_agencypaybill");
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String pageId = (String)variables.get("pageid");
        IAppCache cache = AppCache.get((String)pageId);
        Map seqMap = (Map)cache.get("seqMap", Map.class);
        if (seqMap == null) {
            seqMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        boolean isSplitCur = SWCStringUtils.isEmpty((String)(isSplitCurStr = (String)variables.get("isSplitCur"))) ? false : Boolean.parseBoolean(isSplitCurStr);
        Set billIdSet = (Set)cache.get("billIdSet", Set.class);
        if (billIdSet == null) {
            billIdSet = Sets.newHashSetWithExpectedSize((int)16);
        }
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        Map<String, List<DynamicObject>> detailMap = this.buildSplitDetailMap(dataEntities, orgIdSet, isSplitCur);
        Map<Long, DynamicObject> orgMap = this.queryOrgByIds(orgIdSet);
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList insertParamsList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList updateParamsList = Lists.newArrayListWithExpectedSize((int)10);
        HashMap detailBillMap = Maps.newHashMapWithExpectedSize((int)16);
        ORM orm = ORM.create();
        DynamicObjectCollection saveBill = new DynamicObjectCollection();
        for (Map.Entry<String, List<DynamicObject>> entry : detailMap.entrySet()) {
            String key = entry.getKey();
            String seqInfo = (String)seqMap.get(key);
            List<DynamicObject> details = entry.getValue();
            if (SWCStringUtils.isEmpty((String)seqInfo)) {
                this.log.info("\u7b2c1\u79cd\u60c5\u51b5\uff0c\u76f4\u63a5\u65b0\u589e\u4ee3\u53d1\u5355");
                DynamicObject agencyPayBill = (DynamicObject)type.createInstance();
                DynamicObjectCollection ents = agencyPayBill.getDynamicObjectCollection("entryentity");
                ents.clear();
                this.log.info("before: {}", (Object)ents.size());
                this.setBillData(agencyPayBill, ents, details, userId, nowDate, orgMap);
                this.log.info("after: {}", (Object)ents.size());
                saveBill.add((Object)agencyPayBill);
                continue;
            }
            this.log.info("\u7b2c2\u79cd\u60c5\u51b5\uff0c\u5df2\u6709\u4ee3\u53d1\u5355\u6570\u636e\u4e0a\u5199\u5165");
            String[] infoArr = seqInfo.split("_");
            long billId = Long.parseLong(infoArr[0]);
            int seq = Integer.parseInt(infoArr[1]);
            int waitInsertRows = details.size();
            int availableInsertRows = 10000 - seq + 1;
            if (availableInsertRows == 0) {
                this.log.info("\u7b2c2\u79cd\u60c5\u51b5\u5206\u652f\uff0c\u6ee1\u884c\u9700\u8981\u65b0\u589e\u4e00\u4e2a\u4ee3\u53d1\u5355");
                DynamicObject agencyPayBill = (DynamicObject)type.createInstance();
                DynamicObjectCollection ents = agencyPayBill.getDynamicObjectCollection("entryentity");
                ents.clear();
                this.setBillData(agencyPayBill, ents, details, userId, nowDate, orgMap);
                saveBill.add((Object)agencyPayBill);
                continue;
            }
            if (waitInsertRows <= availableInsertRows) {
                this.log.info("\u7b2c2\u79cd\u60c5\u51b5\u5206\u652f\uff0c\u8fd8\u6709\u4f59\u989d\uff0c\u53ef\u76f4\u63a5\u63d2\u5165");
                long[] entryIds = this.genLongIds(orm, entType, waitInsertRows);
                List<Object[]> objList = this.buildInsertEntParm(billId, entryIds, seq, details, userId, nowDate, updateParamsList, detailBillMap);
                insertParamsList.addAll(objList);
                StringBuilder sb = new StringBuilder();
                sb.append(billId).append('_').append(seq += objList.size());
                seqMap.put(key, sb.toString());
                continue;
            }
            this.log.info("\u7b2c2\u79cd\u60c5\u51b5\u5206\u652f\uff0c\u63d2\u5165\u5b8c\u540e\u8fd8\u6709\u9700\u8981\u65b0\u589e\u7684");
            List<DynamicObject> insertDetails = details.subList(0, availableInsertRows);
            long[] entryIds = this.genLongIds(orm, entType, insertDetails.size());
            List<Object[]> objList = this.buildInsertEntParm(billId, entryIds, seq, insertDetails, userId, nowDate, updateParamsList, detailBillMap);
            insertParamsList.addAll(objList);
            StringBuilder sb = new StringBuilder();
            sb.append(billId).append('_').append(seq += objList.size());
            seqMap.put(key, sb.toString());
            List<DynamicObject> addDetails = details.subList(availableInsertRows, waitInsertRows);
            DynamicObject agencyPayBill = (DynamicObject)type.createInstance();
            DynamicObjectCollection ents = agencyPayBill.getDynamicObjectCollection("entryentity");
            ents.clear();
            this.setBillData(agencyPayBill, ents, addDetails, userId, nowDate, orgMap);
            saveBill.add((Object)agencyPayBill);
        }
        if (!saveBill.isEmpty()) {
            billHelper.save(saveBill);
            this.log.info("saveBill\u7684\u957f\u5ea6\uff1a{}", (Object)saveBill.size());
            this.addSeqInfoIntoCache(saveBill, seqMap, detailBillMap, billIdSet, isSplitCur);
        }
        if (!insertParamsList.isEmpty()) {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getInsertEntSql(), (List)insertParamsList);
            if (!updateParamsList.isEmpty()) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getUpdateBillSql(), (List)updateParamsList);
            }
        }
        cache.put("seqMap", (Object)seqMap);
        cache.put("billIdSet", (Object)billIdSet);
        HashSet calPersonIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            calPersonIdSet.add(entity.getLong("calpersonid"));
            entity.set("agencypaybill", detailBillMap.get(entity.getLong("id")));
            entity.set("agencypaystate", (Object)AgencyPayStateEnum.GENERATED.getCode());
            entity.set("paystate", (Object)PayStateEnum.UNPAY.getCode());
        }
        new SWCDataServiceHelper("hsas_paydetail").save(dataEntities);
        AgencyPayWriteBackService agencyPayWriteBackService = new AgencyPayWriteBackService();
        agencyPayWriteBackService.updateCaltablePayState((Set)calPersonIdSet);
    }

    private Map<Long, DynamicObject> queryOrgByIds(Set<Long> orgIdSet) {
        DynamicObject[] orgArr;
        HashMap orgMap = Maps.newHashMapWithExpectedSize((int)orgIdSet.size());
        for (DynamicObject org : orgArr = AgencyPayHelper.queyOrgByIds(orgIdSet)) {
            orgMap.put(org.getLong("id"), org);
        }
        return orgMap;
    }

    private void setBillData(DynamicObject agencyPayBill, DynamicObjectCollection agencyPayBillEnt, List<DynamicObject> details, long userId, Date nowDate, Map<Long, DynamicObject> orgMap) {
        long orgId = details.get(0).getLong("org.id");
        long grpId = details.get(0).getLong("caltask.payrollgroup.id");
        DynamicObject org = orgMap.get(orgId);
        String orgIdStr = String.valueOf(orgId);
        String orgName = org.getString("name");
        String billNo = CodeRuleHelper.getNumber((DynamicObject)agencyPayBill, (String)orgIdStr);
        agencyPayBill.set("billno", (Object)billNo);
        agencyPayBill.set("billname", (Object)AgencyPayHelper.createDefaultBillName((String)billNo, (String)orgName));
        agencyPayBill.set("org", (Object)orgId);
        agencyPayBill.set("creator", (Object)userId);
        agencyPayBill.set("createtime", (Object)nowDate);
        agencyPayBill.set("auditstatus", (Object)"A");
        agencyPayBill.set("billstatus", (Object)"A");
        agencyPayBill.set("payrollgrp", (Object)grpId);
        int size = details.size();
        DynamicObject ent = null;
        int i = 1;
        for (DynamicObject detail : details) {
            ent = agencyPayBillEnt.addNew();
            ent.set("seq", (Object)i++);
            this.setBillEnt(ent, detail, userId, nowDate);
        }
        agencyPayBill.set("totalcount", (Object)size);
        agencyPayBill.set("unpaycount", (Object)0);
        agencyPayBill.set("paidcount", (Object)0);
    }

    private void setBillEnt(DynamicObject ent, DynamicObject detail, long userId, Date nowDate) {
        DynamicObject paySubjectHis = detail.getDynamicObject("paysubjecthis");
        long paySubjectvId = paySubjectHis.getLong("id");
        long agentPayOrgId = detail.getLong("agentpayorg.id");
        long perBankCardId = detail.getLong("perbankcard.id");
        long payTypeId = detail.getLong("paytype.id");
        ent.set("salaryfilehis", (Object)detail.getString("salaryfilehis.id"));
        ent.set("paydetail", (Object)detail);
        ent.set("paysubjectv", (Object)paySubjectvId);
        ent.set("agentpayorg", (Object)agentPayOrgId);
        ent.set("operator", (Object)userId);
        ent.set("operatedate", (Object)nowDate);
        ent.set("payrollgroup", (Object)detail.getLong("caltask.payrollgroup.id"));
        ent.set("paystate", (Object)"0");
        ent.set("perbankcardv", (Object)perBankCardId);
        ent.set("paytype", (Object)payTypeId);
    }

    private void addSeqInfoIntoCache(DynamicObjectCollection saveBill, Map<String, String> seqMap, Map<Long, Long> detailBillMap, Set<String> billIdSet, boolean isSplitCur) {
        for (DynamicObject data : saveBill) {
            long billId = data.getLong("id");
            billIdSet.add(String.valueOf(billId));
            DynamicObjectCollection cols = data.getDynamicObjectCollection("entryentity");
            this.noteDetailBillIdMap(cols, billId, detailBillMap);
            int size = cols.size();
            this.log.info("\u4ee3\u53d1\u5355\u5206\u5f55\u7684\u957f\u5ea6\uff1a{}", (Object)size);
            String key = this.getKey(((DynamicObject)cols.get(0)).getDynamicObject("paydetail"), isSplitCur);
            String seqInfo = seqMap.get(key);
            StringBuilder sb = new StringBuilder();
            if (SWCStringUtils.isEmpty((String)seqInfo)) {
                sb.append(billId).append('_').append(size + 1);
            } else {
                String[] seqInfoArr = seqInfo.split("_");
                long oldbillId = Long.parseLong(seqInfoArr[0]);
                int oldSeq = Integer.parseInt(seqInfoArr[1]);
                if (oldbillId == billId) {
                    sb.append(oldbillId).append('_').append(oldSeq += size);
                } else {
                    sb.append(billId).append('_').append(size + 1);
                }
            }
            seqMap.put(key, sb.toString());
        }
    }

    private void noteDetailBillIdMap(DynamicObjectCollection cols, long billId, Map<Long, Long> detailBillMap) {
        for (DynamicObject col : cols) {
            detailBillMap.put(col.getLong("paydetail.id"), billId);
        }
    }

    private EntityType getAgencyBillEntDataType(MainEntityType mainType) {
        EntityType entType = (EntityType)mainType.getAllEntities().get("entryentity");
        return entType;
    }

    private long[] genLongIds(ORM orm, EntityType type, int count) {
        return orm.genLongIds((IDataEntityType)type, count);
    }

    private List<Object[]> buildInsertEntParm(long billId, long[] entryIds, int seqBegin, List<DynamicObject> details, long userId, Date nowDate, List<Object[]> updateParamsList, Map<Long, Long> detailBillMap) {
        ArrayList insertParmList = Lists.newArrayListWithExpectedSize((int)details.size());
        ArrayList updateParm = Lists.newArrayListWithExpectedSize((int)details.size());
        int i = 0;
        int seq = seqBegin;
        for (DynamicObject detail : details) {
            ArrayList insertParm = Lists.newArrayListWithExpectedSize((int)details.size());
            DynamicObject paySubjectHis = detail.getDynamicObject("paysubjecthis");
            long paySubjectId = paySubjectHis.getLong("id");
            long agentPayOrgId = detail.getLong("agentpayorg.id");
            long detailId = detail.getLong("id");
            detailBillMap.put(detailId, billId);
            insertParm.add(billId);
            insertParm.add(entryIds[i++]);
            insertParm.add(seq++);
            insertParm.add(detailId);
            insertParm.add(detail.getLong("salaryfilehis.id"));
            insertParm.add(paySubjectId);
            insertParm.add(agentPayOrgId);
            insertParm.add(userId);
            insertParm.add(nowDate);
            insertParm.add(detail.getLong("caltask.payrollgroup.id"));
            insertParm.add(detail.getLong("perbankcard.id"));
            insertParm.add(detail.getLong("paytype.id"));
            insertParmList.add(insertParm.toArray());
        }
        updateParm.add(--seq);
        updateParm.add(billId);
        updateParamsList.add(updateParm.toArray());
        return insertParmList;
    }

    private String getInsertEntSql() {
        return "insert into t_hsas_agencypayent(FID, FENTRYID, FSEQ, FPAYDETAILID, FSALARYFILEVID, FPAYSUBJECTVID, FAGENTPAYORGID, FOPERATORID, FOPERATEDATE, FPAYROLLGROUPID, FPERBANKCARDVID, FPAYTYPEID) values(?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    private String getUpdateBillSql() {
        return "update t_hsas_agencypaybill set ftotalcount=? where FID = ?";
    }

    private Map<String, List<DynamicObject>> buildSplitDetailMap(DynamicObject[] details, Set<Long> orgIdSet, boolean isSplitCur) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)details.length);
        for (DynamicObject detail : details) {
            orgIdSet.add(detail.getLong("org.id"));
            String key = this.getKey(detail, isSplitCur);
            List tempList = (List)map.get(key);
            if (tempList == null) {
                tempList = Lists.newArrayListWithExpectedSize((int)10);
            }
            tempList.add(detail);
            map.put(key, tempList);
        }
        return map;
    }

    private String getKey(DynamicObject detail, boolean isSplit) {
        StringBuilder key = new StringBuilder();
        String orgId = detail.getString("org.id");
        String grpId = detail.getString("caltask.payrollgroup.id");
        if (!isSplit) {
            key.append(orgId).append('-').append(grpId);
            return key.toString();
        }
        String curId = detail.getString("paycurrency.id");
        key.append(orgId).append('-').append(grpId).append('-').append(curId);
        return key.toString();
    }
}

