/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CalApproveBillTplOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] dataEntities;
        String action = this.getOption().getVariableValue("onlyValidate", "");
        if (StringUtils.equals((CharSequence)action, (CharSequence)"true")) {
            args.setCancel(true);
        }
        if ("save".equals(args.getOperationKey()) && !ArrayUtils.isEmpty((Object[])(dataEntities = args.getDataEntities()))) {
            for (Object entity : dataEntities) {
                entity.set("iseffect", (Object)Boolean.TRUE);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        String key = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        if ("auditconfirmchange".equals(key)) {
            this.updateBoDatas(dataEntities);
        } else if ("audit".equals(key)) {
            this.updateVerDatas(dataEntities);
        } else if ("changesave".equals(key)) {
            this.updateTmpDatas(dataEntities);
        }
    }

    private void updateVerDatas(DynamicObject[] dataEntities) {
        ArrayList vids = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            vids.add(dataEntity.getLong("sourcevid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter qfilter = new QFilter("id", "in", (Object)vids);
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_approvebilltpl");
        DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{qfilter}, null);
        this.assembleDatas(dynamicObjects);
        helper.save(dynamicObjects);
    }

    private void updateBoDatas(DynamicObject[] dataEntities) {
        ArrayList ids = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            ids.add(dataEntity.getLong("boid"));
            ids.add(dataEntity.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter qfilter = new QFilter("id", "in", (Object)ids);
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_approvebilltpl");
        DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{qfilter}, null);
        this.assembleDatas(dynamicObjects);
        helper.save(dynamicObjects);
    }

    private void updateTmpDatas(DynamicObject[] dataEntities) {
        ArrayList boids = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            boids.add(dataEntity.getLong("boid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter qfilter = new QFilter("boid", "in", (Object)boids);
        qfilter.and("datastatus", "=", (Object)"-3");
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_approvebilltpl");
        DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{qfilter}, null);
        this.assembleDatas(dynamicObjects);
        helper.save(dynamicObjects);
    }

    private void assembleDatas(DynamicObject[] dynamicObjects) {
        for (DynamicObject data : dynamicObjects) {
            ApproveSettingHelper.assembleData((DynamicObject)data);
        }
    }
}

