/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveAbandonedValidator;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class CalApproveAbandonedOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new CalApproveAbandonedValidator());
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] entities = args.getDataEntities();
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        for (DynamicObject entry : entities) {
            pkIdList.add(entry.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        DynamicObject[] approveBillList = ApproveBillService.getApproveBillList(pkIdList, (SWCDataServiceHelper)helper);
        ArrayList<Long> calPersonIds = new ArrayList<Long>(10);
        ArrayList<DynamicObject> successData = new ArrayList<DynamicObject>(approveBillList.length);
        for (DynamicObject approveBillDy : approveBillList) {
            if (!"G".equals(approveBillDy.getString("billstatus")) || !this.workFlowAbandon(approveBillDy)) continue;
            approveBillDy.set("billstatus", (Object)"F");
            DynamicObjectCollection calPersonEntry = approveBillDy.getDynamicObjectCollection("calentryentity");
            calPersonEntry.forEach(calPerson -> calPersonIds.add(calPerson.getLong("calpersonid")));
            successData.add(approveBillDy);
        }
        this.chageCalstate(calPersonIds);
        helper.update(approveBillList);
        args.setDataEntities(successData.toArray(new DynamicObject[0]));
    }

    private void chageCalstate(List<Long> calPersonIds) {
        DynamicObject[] calTableArr;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        for (DynamicObject calTableDy : calTableArr = helper.query("id,calstatus", new QFilter[]{filter})) {
            calTableDy.set("calstatus", (Object)"3");
        }
        helper.update(calTableArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean workFlowAbandon(DynamicObject approveBillDy) {
        try (TXHandle txHandle = TX.requiresNew();){
            String businessKey = approveBillDy.getString("id");
            if (WorkflowServiceHelper.inProcess((String)businessKey)) {
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            boolean bl = true;
            return bl;
        }
    }

    private void setErrorMsg(Long id, String billNo) {
        ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo();
        validationErrorInfo.setMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5de5\u4f5c\u6d41\u6b63\u5728\u6d41\u8f6c\uff0c\u65e0\u6cd5\u5e9f\u5f03\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalApproveAbandonedOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), billNo));
        validationErrorInfo.setPkValue((Object)id);
        validationErrorInfo.setErrorLevel(ErrorLevel.Error.toString());
        this.operationResult.addErrorInfo((OperateErrorInfo)validationErrorInfo);
    }
}

