/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.common.dto.ApproveBillAccountDTO;
import kd.swc.hsas.common.dto.NeedUpdateCalPersonDTO;
import kd.swc.hsas.common.enums.HSASErrInfoEnum;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveCreateBillValidator;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalApproveBillCreateOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CalApproveBillCreateOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("org.id");
        fieldKeys.add("org.name");
        fieldKeys.add("payrollgroup.name");
        fieldKeys.add("payrollgroup.name");
        fieldKeys.add("salaryfile.employee.id");
        fieldKeys.add("empnumber");
        fieldKeys.add("name");
        fieldKeys.add("salaryfile.id");
        fieldKeys.add("salaryfile.number");
        fieldKeys.add("salaryfile.status");
        fieldKeys.add("calstatus");
        fieldKeys.add("onholdstatus");
        fieldKeys.add("paystatus");
        fieldKeys.add("calresultid");
        fieldKeys.add("salaryfilev");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalApproveCreateBillValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String approveBillTplId = (String)variables.get("approveBillTplId");
        SWCDataServiceHelper apvSchemeHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        Boolean isPayDetail = ApproveBillService.isPayDetail((DynamicObject)apvSchemeHelper.loadSingle((Object)approveBillTplId));
        DynamicObject[] dataEntities = args.getDataEntities();
        Set unPayDetailCalPersonIds = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        Map payDetails = HSASCalApproveBillHelper.queryPayDetails(unPayDetailCalPersonIds);
        HashMap<Long, NeedUpdateCalPersonDTO> needUpdateCalPersonCalPayDetailMap = new HashMap<Long, NeedUpdateCalPersonDTO>(10);
        HashMap<Long, Long> needUpdateCalPersonMap = new HashMap<Long, Long>(10);
        ArrayList<Long> needUpdateApproveBillEntList = new ArrayList<Long>(10);
        NeedUpdateCalPersonDTO needUpdateCalPersonDTO = null;
        for (DynamicObject dynamicObject2 : dataEntities) {
            long id = dynamicObject2.getLong("id");
            long calResultId = dynamicObject2.getLong("calresultid");
            if (!CollectionUtils.isEmpty((Map)payDetails) && isPayDetail.booleanValue()) {
                Set payDetailIdSet = (Set)payDetails.get(id);
                needUpdateCalPersonDTO = new NeedUpdateCalPersonDTO(Long.valueOf(calResultId), payDetailIdSet);
                needUpdateCalPersonCalPayDetailMap.put(id, needUpdateCalPersonDTO);
            } else {
                needUpdateCalPersonMap.put(id, calResultId);
            }
            String calstatus = dynamicObject2.getString("calstatus");
            if (!CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calstatus)) continue;
            needUpdateApproveBillEntList.add(id);
        }
        String pageId = (String)variables.get("pageid");
        ISWCAppCache appCache = SWCAppCache.get((String)pageId);
        try {
            this.createNewApproveBill(dataEntities, appCache, needUpdateCalPersonCalPayDetailMap, needUpdateCalPersonMap, isPayDetail);
        }
        catch (Exception exception) {
            boolean isInValid;
            boolean isSystemError = exception instanceof KDException && HRStringUtils.equals((String)HSASErrInfoEnum.COMMON_SYSTEM_ERROR.getErrCode(), (String)((KDException)exception).getErrorCode().getCode());
            boolean bl = isInValid = isSystemError || CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception) != null;
            if (isInValid) {
                for (DynamicObject dataEntity : dataEntities) {
                    this.getOperationResult().addErrorInfo((OperateErrorInfo)this.buildErrMessage(dataEntity, (KDException)exception));
                }
                this.getOperationResult().setShowMessage(true);
                this.getOperationResult().setSuccess(false);
                args.setDataEntities(new DynamicObject[0]);
                return;
            }
            throw exception;
        }
        this.updateApproveBillEntState(needUpdateApproveBillEntList);
    }

    private void updateApproveBillEntState(List<Long> needUpdateApproveBillEntList) {
        if (needUpdateApproveBillEntList.isEmpty()) {
            return;
        }
        StringBuilder stateSql = new StringBuilder("update t_hsas_approvebillent set fauditstatus = '0' where fcalpersonid in (");
        Object[] entryIds = needUpdateApproveBillEntList.toArray();
        for (int i = 0; i < entryIds.length; ++i) {
            stateSql.append('?');
            if (i + 1 >= entryIds.length) continue;
            stateSql.append(',');
        }
        stateSql.append(')');
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)stateSql.toString(), (Object[])entryIds);
    }

    private void updateCalPersonState(Set<Long> calPersonIdList) {
        if (calPersonIdList.isEmpty()) {
            return;
        }
        StringBuilder stateSql = new StringBuilder("update t_hsas_calperson_s set fcalstatus = '11' where fid in (");
        Object[] entryIds = calPersonIdList.toArray();
        for (int i = 0; i < entryIds.length; ++i) {
            stateSql.append('?');
            if (i + 1 >= entryIds.length) continue;
            stateSql.append(',');
        }
        stateSql.append(')');
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)stateSql.toString(), (Object[])entryIds);
    }

    protected void createNewApproveBill(DynamicObject[] dataEntities, ISWCAppCache appCache, Map<Long, NeedUpdateCalPersonDTO> needUpdateCalPersonCalPayDetailMap, Map<Long, Long> needUpdateCalPersonMap, Boolean isPayDetail) {
        HashSet<Long> calPersonIdList = new HashSet(16);
        if (!CollectionUtils.isEmpty(needUpdateCalPersonCalPayDetailMap) && CollectionUtils.isEmpty(needUpdateCalPersonMap)) {
            calPersonIdList = needUpdateCalPersonCalPayDetailMap.keySet();
        } else if (!CollectionUtils.isEmpty(needUpdateCalPersonMap) && CollectionUtils.isEmpty(needUpdateCalPersonCalPayDetailMap)) {
            calPersonIdList = needUpdateCalPersonMap.keySet();
        }
        Map<String, Integer> personNumAndTime = this.getPersonNumAndFileNum(dataEntities, appCache);
        Map variables = this.getOption().getVariables();
        String calTaskIdStr = (String)variables.get("taskId");
        Set calTableIds = Arrays.stream(dataEntities).map(calPersonDy -> calPersonDy.getLong("calresultid")).collect(Collectors.toSet());
        ApproveBillAccountDTO approveBillAccountDTO = ApproveBillService.getItemInfoInCalTable(calTableIds);
        Long approveBillId = this.generateApproveBill(appCache, calTaskIdStr, personNumAndTime, approveBillAccountDTO);
        long begin = System.currentTimeMillis();
        this.setCalApproveBillEntry(needUpdateCalPersonCalPayDetailMap, needUpdateCalPersonMap, approveBillId);
        log.info("inset ent cost :{}", (Object)(System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        this.updateCalPersonState(calPersonIdList);
        log.info("update cal cost :{}", (Object)(System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        log.info("save bill cost :{}", (Object)(System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        if (isPayDetail.booleanValue()) {
            ApproveBillService.updatePayDetail((Long)approveBillId, new ArrayList<Long>(calPersonIdList));
        }
        log.info("update detail cost :{}", (Object)(System.currentTimeMillis() - begin));
    }

    private Long generateApproveBill(ISWCAppCache appCache, String calTaskIdStr, Map<String, Integer> personNumAndTime, ApproveBillAccountDTO approveBillAccountDTO) {
        DynamicObject approveBillDy;
        String approveBillNo = (String)appCache.get(calTaskIdStr + "approveBillNo", String.class);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        if (SWCStringUtils.isNotEmpty((String)approveBillNo)) {
            approveBillDy = helper.queryOne("totalpersonnum,totalsalaryfilenum", new QFilter[]{new QFilter("billno", "=", (Object)approveBillNo)});
            if (approveBillDy == null) {
                approveBillDy = helper.generateEmptyDynamicObject();
                this.setBillData(approveBillDy, personNumAndTime);
                approveBillNo = approveBillDy.getString("billno");
                appCache.put(calTaskIdStr + "approveBillNo", (Object)approveBillNo);
            } else {
                approveBillDy.set("totalpersonnum", (Object)personNumAndTime.get("personIdNum"));
                approveBillDy.set("totalsalaryfilenum", (Object)personNumAndTime.get("totalSalaryFileNum"));
            }
        } else {
            approveBillDy = helper.generateEmptyDynamicObject();
            this.setBillData(approveBillDy, personNumAndTime);
            approveBillNo = approveBillDy.getString("billno");
            appCache.put(calTaskIdStr + "approveBillNo", (Object)approveBillNo);
        }
        approveBillAccountDTO.setApproveBillId(Long.valueOf(approveBillDy.getLong("id")));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approveBillDy});
        ApproveBillService.updateItemAccountDy((ApproveBillAccountDTO)approveBillAccountDTO);
        return approveBillDy.getLong("id");
    }

    private void setCalApproveBillEntry(Map<Long, NeedUpdateCalPersonDTO> needUpdateCalPersonCalPayDetailMap, Map<Long, Long> needUpdateCalPersonMap, Long fId) {
        if (!CollectionUtils.isEmpty(needUpdateCalPersonCalPayDetailMap) && CollectionUtils.isEmpty(needUpdateCalPersonMap)) {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getInsertFieldSql(), this.getInsertPayDetailFieldParam(needUpdateCalPersonCalPayDetailMap, fId));
        } else if (!CollectionUtils.isEmpty(needUpdateCalPersonMap) && CollectionUtils.isEmpty(needUpdateCalPersonCalPayDetailMap)) {
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getInsertFieldSql(), this.getInsertFieldParam(needUpdateCalPersonMap, fId));
        }
    }

    private Map<String, Integer> getPersonNumAndFileNum(DynamicObject[] dataEntities, ISWCAppCache appCache) {
        HashSet<Long> salaryFileIdSet;
        HashSet<Long> personIdSet = (HashSet<Long>)appCache.get("approvePersonSet", HashSet.class);
        if (personIdSet == null) {
            personIdSet = new HashSet<Long>(16);
        }
        if ((salaryFileIdSet = (HashSet<Long>)appCache.get("approveFileSet", HashSet.class)) == null) {
            salaryFileIdSet = new HashSet<Long>(16);
        }
        HashMap<String, Integer> personNumMap = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : dataEntities) {
            Long id = dynamicObject.getLong("id");
            personIdSet.add(dynamicObject.getLong("salaryfile.employee.id"));
            salaryFileIdSet.add(dynamicObject.getLong("salaryfile.id"));
        }
        appCache.put("approvePersonSet", personIdSet);
        appCache.put("approveFileSet", salaryFileIdSet);
        personNumMap.put("personIdNum", personIdSet.size());
        personNumMap.put("totalSalaryFileNum", salaryFileIdSet.size());
        return personNumMap;
    }

    private void setBillData(DynamicObject approveBillDy, Map<String, Integer> personNumAndTime) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String approveBillTplId = (String)variables.get("approveBillTplId");
        String approveBillTplHisId = (String)variables.get("approveBillTplHisId");
        String orgIdStr = (String)variables.get("orgId");
        String payrollgroupIdStr = (String)variables.get("payrollgroupId");
        String orgName = (String)variables.get("orgName");
        String calTaskIdStr = (String)variables.get("taskId");
        HSASCalApproveBillHelper.setCalTasks((DynamicObject)approveBillDy, (String)calTaskIdStr);
        String payRollGroupStr = (String)variables.get("payrollgroupid");
        HSASCalApproveBillHelper.setPayRollGroups((DynamicObject)approveBillDy, (String)payRollGroupStr);
        Integer personNum = personNumAndTime.get("personIdNum");
        Integer totalSalaryFileNum = personNumAndTime.get("totalSalaryFileNum");
        String billNo = CodeRuleHelper.getNumber((DynamicObject)approveBillDy, (String)orgIdStr);
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        long fId = DB.genLongId((String)"t_hsas_approvebill");
        HSASCalApproveBillHelper calApproveHelper = new HSASCalApproveBillHelper();
        String billName = calApproveHelper.createDefaultBillName(orgName, nowDate);
        approveBillDy.set("id", (Object)fId);
        approveBillDy.set("billno", (Object)billNo);
        approveBillDy.set("billname", (Object)billName);
        approveBillDy.set("org", (Object)orgIdStr);
        if (calTaskIdStr.split(",").length < 2) {
            approveBillDy.set("payrollgroup", (Object)payrollgroupIdStr);
        }
        approveBillDy.set("creator", (Object)userId);
        approveBillDy.set("modifier", (Object)userId);
        approveBillDy.set("createtime", (Object)nowDate);
        approveBillDy.set("modifytime", (Object)nowDate);
        approveBillDy.set("approvebilltpl", (Object)approveBillTplId);
        approveBillDy.set("approvebilltplv", (Object)approveBillTplHisId);
        approveBillDy.set("totalpersonnum", (Object)personNum);
        approveBillDy.set("totalsalaryfilenum", (Object)totalSalaryFileNum);
        approveBillDy.set("billstatus", (Object)"A");
        approveBillDy.set("auditstatus", (Object)"A");
        String[] caltaskIds = calTaskIdStr.split(",");
        List calTaskIdList = Arrays.stream(caltaskIds).map(Long::valueOf).collect(Collectors.toList());
        calApproveHelper.afterSetBillData(approveBillDy, calTaskIdList);
    }

    private String getInsertFieldSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(" INSERT INTO ").append("T_HSAS_APPROVEBILLENT").append(" (FENTRYID,FID,FSEQ,FAUDITSTATUS,").append("FCALTABLEID,FPAYDETAILID,FCALPERSONID ) ").append(" VALUES ").append(" (?,?,?,?,?,?,?) ");
        return sb.toString();
    }

    private List<Object[]> getInsertPayDetailFieldParam(Map<Long, NeedUpdateCalPersonDTO> needUpdateCalPersonCalPayDetailMap, Long fId) {
        String sqlCount = "select count(a.fentryid) from t_hsas_approvebillent a where FID = " + fId;
        Integer num = (Integer)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sqlCount, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                Integer num = 0;
                while (rs.next()) {
                    num = rs.getInt(1);
                }
                return num;
            }
        });
        ArrayList<Object[]> params = new ArrayList<Object[]>(needUpdateCalPersonCalPayDetailMap.size());
        Iterator<Map.Entry<Long, NeedUpdateCalPersonDTO>> iterator = needUpdateCalPersonCalPayDetailMap.entrySet().iterator();
        int size = 0;
        while (iterator.hasNext()) {
            Map.Entry<Long, NeedUpdateCalPersonDTO> next = iterator.next();
            NeedUpdateCalPersonDTO value = next.getValue();
            if (value.getPayDetailIdSet() != null) {
                size += value.getPayDetailIdSet().size();
                continue;
            }
            ++size;
        }
        long[] ids = DB.genLongIds((String)"t_hsas_approvebillent", (int)size);
        int index = 0;
        for (Map.Entry<Long, NeedUpdateCalPersonDTO> calPersonCalTableEntry : needUpdateCalPersonCalPayDetailMap.entrySet()) {
            NeedUpdateCalPersonDTO needUpdateCalPersonDTO = calPersonCalTableEntry.getValue();
            if (needUpdateCalPersonDTO == null) continue;
            Set detailIdSet = needUpdateCalPersonDTO.getPayDetailIdSet();
            if (detailIdSet != null) {
                for (Long detailId : detailIdSet) {
                    Object[] param = new Object[]{ids[index], fId, num + 1, Character.valueOf(' '), needUpdateCalPersonDTO.getCalResultId(), detailId, calPersonCalTableEntry.getKey()};
                    ++index;
                    params.add(param);
                }
                continue;
            }
            Object[] param = new Object[]{ids[index], fId, num + 1, Character.valueOf(' '), needUpdateCalPersonDTO.getCalResultId(), 0L, calPersonCalTableEntry.getKey()};
            ++index;
            params.add(param);
        }
        return params;
    }

    private List<Object[]> getInsertFieldParam(Map<Long, Long> needUpdateCalPersonMap, Long fId) {
        String sqlCount = "select count(a.fentryid) from t_hsas_approvebillent a where FID = " + fId;
        Integer num = (Integer)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sqlCount, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                Integer num = 0;
                while (rs.next()) {
                    num = rs.getInt(1);
                }
                return num;
            }
        });
        ArrayList<Object[]> params = new ArrayList<Object[]>(needUpdateCalPersonMap.size());
        long[] ids = DB.genLongIds((String)"t_hsas_approvebillent", (int)needUpdateCalPersonMap.size());
        int index = 0;
        for (Map.Entry<Long, Long> calPersonCalTableEntry : needUpdateCalPersonMap.entrySet()) {
            Object[] param = new Object[]{ids[index], fId, num + 1, Character.valueOf(' '), calPersonCalTableEntry.getValue(), 0L, calPersonCalTableEntry.getKey()};
            ++index;
            params.add(param);
        }
        return params;
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDException exp) {
        ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo();
        validationErrorInfo.setMessage(exp.getErrorCode().getMessage());
        validationErrorInfo.setPkValue(obj.getPkValue());
        validationErrorInfo.setErrorLevel(ErrorLevel.Error.toString());
        return validationErrorInfo;
    }
}

