/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveDeleteBillValidator;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class CalApproveBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("caltasks");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalApproveDeleteBillValidator());
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<Long> approveBillIdList = new ArrayList<Long>(10);
            ArrayList calTaskIdSet = new ArrayList(16);
            for (DynamicObject dataEntity : dataEntities) {
                String billStatus = dataEntity.getString("billstatus");
                if (!"A".equals(billStatus)) continue;
                approveBillIdList.add(dataEntity.getLong("id"));
                calTaskIdSet.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dataEntity));
            }
            HSASCalApproveBillHelper approveBillHelper = new HSASCalApproveBillHelper();
            HashMap<Long, Integer> unAuditCalPersonMap = new HashMap<Long, Integer>(16);
            Map calPersonMap = approveBillHelper.getNotPassCalPersonIds(calTaskIdSet, unAuditCalPersonMap);
            HSASCalApproveBillHelper helper = new HSASCalApproveBillHelper();
            this.updateCalPersonCalstate(approveBillIdList, calPersonMap, helper, unAuditCalPersonMap);
            for (Long calTaskId : calTaskIdSet) {
                PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
            }
            QFilter accountFilter = new QFilter("approvebill", "in", approveBillIdList);
            HRBaseServiceHelper.create((String)"hsas_itemaccount").deleteByFilter(accountFilter.toArray());
        }
    }

    protected void updateCalPersonCalstate(List<Long> approveBillIdList, Map<Long, Integer> calPersonMap, HSASCalApproveBillHelper helper, Map<Long, Integer> unAuditCalPersonMap) {
        DynamicObject[] calList;
        SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calperson");
        for (DynamicObject cal : calList = helper.getNeedUpdateCalPersonList(approveBillIdList, calHelper)) {
            long id = cal.getLong("id");
            if (calPersonMap.containsKey(id) && !unAuditCalPersonMap.containsKey(id)) {
                cal.set("calstatus", (Object)CalStateEnum.APPROVALED_NOT_PASS.getCode());
                continue;
            }
            cal.set("calstatus", (Object)CalStateEnum.AUDIT.getCode());
        }
        calHelper.update(calList);
    }
}

