/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class CalApproveBillEventOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(CalApproveBillEventOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("caltasks");
        fieldKeys.add("approvebilltplv");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] regBillObjs = args.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(10);
        HashSet calTaskIds = new HashSet(regBillObjs.length);
        for (DynamicObject dynamicObject : regBillObjs) {
            long id = dynamicObject.getLong("id");
            billIdList.add(id);
            calTaskIds.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dynamicObject));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        QFilter filter = new QFilter("id", "in", billIdList);
        DynamicObject[] needUpdateBillDy = helper.query("id,billstatus,recentapprovedate,calentryentity.caltableid,calpersonid", new QFilter[]{filter});
        List<Long> needUpdateCalPersonIdList = this.getNeedUpdateCalPersonIdList(needUpdateBillDy);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calTableFilter = new QFilter("id", "in", needUpdateCalPersonIdList);
        DynamicObject[] needUpdateCalPersonDy = calPersonHelper.query("id,calresultid,calstatus,caltask.id", new QFilter[]{calTableFilter});
        switch (args.getOperationKey()) {
            case "wfauditnotpass": {
                this.setApproveStatus(needUpdateBillDy, "E");
                this.setCalStatus(calPersonHelper, needUpdateCalPersonDy, CalStateEnum.APPROVALED_NOT_PASS.getCode());
                break;
            }
            case "wfrejecttosubmit": {
                this.setApproveStatus(needUpdateBillDy, "G");
                this.setCalStatus(calPersonHelper, needUpdateCalPersonDy, CalStateEnum.WAIT_APPROVALED.getCode());
                break;
            }
            case "wfauditing": {
                this.setApproveStatus(needUpdateBillDy, "D");
                this.setCalStatus(calPersonHelper, needUpdateCalPersonDy, CalStateEnum.APPROVALING.getCode());
                break;
            }
            case "wfauditpass": {
                this.setApproveStatus(needUpdateBillDy, "C");
                this.setCalStatus(calPersonHelper, needUpdateCalPersonDy, CalStateEnum.APPROVALED.getCode());
                this.updatePayDetail(needUpdateCalPersonIdList);
                break;
            }
        }
        helper.update(needUpdateBillDy);
        for (Long calTaskId : calTaskIds) {
            String lockKey = "swc_updateCalApproveBillTask_" + calTaskId;
            try {
                DLock lock = DLock.create((String)lockKey);
                Throwable throwable = null;
                try {
                    if (!lock.tryLock(30000L)) continue;
                    PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lock == null) continue;
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lock.close();
                }
            }
            catch (Exception e) {
                LOGGER.info("lock time out calTaskId is: {}", (Object)calTaskId);
                LOGGER.info("lock time out: {}", (Object)e.getMessage());
            }
        }
    }

    private void updatePayDetail(List<Long> calPersonIdList) {
        DynamicObject[] payDetailArr;
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        filter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("paystate", "=", (Object)"0"));
        for (DynamicObject payDetailDy : payDetailArr = payDetailHelper.query("id,caltableid,paystate", new QFilter[]{filter})) {
            payDetailDy.set("paystate", (Object)"1");
        }
        payDetailHelper.save(payDetailArr);
    }

    protected List<Long> getNeedUpdateCalPersonIdList(DynamicObject[] needUpdateBillDy) {
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
        for (DynamicObject approveBillDy : needUpdateBillDy) {
            DynamicObjectCollection dynamicObjectCollection = approveBillDy.getDynamicObjectCollection("calentryentity");
            for (DynamicObject entryDy : dynamicObjectCollection) {
                calPersonIdList.add(entryDy.getLong("calpersonid"));
            }
        }
        return calPersonIdList;
    }

    private void setApproveStatus(DynamicObject[] regBillObjs, String billstatus) {
        for (DynamicObject dynamicObject : regBillObjs) {
            dynamicObject.set("billstatus", (Object)billstatus);
            dynamicObject.set("recentapprovedate", (Object)new Date());
        }
    }

    private void setCalStatus(SWCDataServiceHelper calPersonHelper, DynamicObject[] regBillObjs, String billStatus) {
        for (DynamicObject dynamicObject : regBillObjs) {
            dynamicObject.set("calstatus", (Object)billStatus);
        }
        calPersonHelper.update(regBillObjs);
    }
}

