/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.common.dto.ApproveBillAccountDTO;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class CalApproveBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CalApproveBillSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String source = (String)variables.get("source");
        if (!"FormBill".equals(source)) {
            return;
        }
        String pageId = (String)variables.get("pageid");
        ISWCAppCache appCache = SWCAppCache.get((String)pageId);
        List allCalPersonIdList = (List)appCache.get("entryCalTableIds", List.class);
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> calTaskIdSet = new ArrayList<Long>(16);
        Long approveBillId = 0L;
        for (DynamicObject dataEntity : dataEntities) {
            calTaskIdSet.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dataEntity));
            approveBillId = dataEntity.getLong("id");
        }
        String operationKey = args.getOperationKey();
        if ("save".equals(operationKey)) {
            this.updateCalPersonStateToWait(allCalPersonIdList);
            this.updateCalPersonStateToAudit(appCache, calTaskIdSet);
            ApproveBillAccountDTO cacheApproveBillAccountDTO = this.getApproveBillAccountDTO(pageId);
            ApproveBillService.saveAdjustedItemAccountDy((ApproveBillAccountDTO)cacheApproveBillAccountDTO);
            if (ApproveBillService.isPayDetail((DynamicObject)dataEntities[0].getDynamicObject("approvebilltplv")).booleanValue()) {
                Set updatePayDetailCalPersonIds = (Set)appCache.get("updatePayDetailCalPersons", Set.class);
                if (!CollectionUtils.isEmpty((Collection)updatePayDetailCalPersonIds)) {
                    ArrayList calPersonIdList = new ArrayList(updatePayDetailCalPersonIds);
                    ApproveBillService.updatePayDetail((Long)approveBillId, calPersonIdList);
                }
            } else {
                ApproveBillService.updatePayDetail((Long)0L, (List)allCalPersonIdList);
            }
        }
    }

    protected void updateCalPersonStateToAudit(ISWCAppCache appCache, List<Long> calTaskIdSet) {
        List deleteCalPersonStrIds = (List)appCache.get("deleteCalTableIds", List.class);
        ArrayList<Long> deleteCalPersonIds = new ArrayList<Long>(10);
        if (CollectionUtils.isEmpty((Collection)deleteCalPersonStrIds)) {
            return;
        }
        deleteCalPersonStrIds.forEach(id -> deleteCalPersonIds.add(Long.parseLong(id)));
        HSASCalApproveBillHelper approveBillHelper = new HSASCalApproveBillHelper();
        HashMap<Long, Integer> unAuditCalPersonMap = new HashMap<Long, Integer>(16);
        Map calPersonMap = approveBillHelper.getNotPassCalPersonIds(calTaskIdSet, unAuditCalPersonMap);
        this.saveCalPersonStatus(deleteCalPersonIds, unAuditCalPersonMap, calPersonMap);
        ApproveBillService.updatePayDetail((Long)0L, deleteCalPersonIds);
    }

    protected void saveCalPersonStatus(List<Long> deleteCalPersonIds, Map<Long, Integer> unAuditCalPersonMap, Map<Long, Integer> calPersonMap) {
        DynamicObject[] queryResults;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", deleteCalPersonIds);
        for (DynamicObject cal : queryResults = helper.query("calstatus", new QFilter[]{filter})) {
            long id = cal.getLong("id");
            if (calPersonMap.containsKey(id) && !unAuditCalPersonMap.containsKey(id)) {
                cal.set("calstatus", (Object)CalStateEnum.APPROVALED_NOT_PASS.getCode());
                continue;
            }
            cal.set("calstatus", (Object)CalStateEnum.AUDIT.getCode());
        }
        helper.save(queryResults);
    }

    protected void updateCalPersonStateToWait(List<Long> allCalPersonIdList) {
        DynamicObject[] queryResults;
        if (CollectionUtils.isEmpty(allCalPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", allCalPersonIdList);
        for (DynamicObject dynamicObject : queryResults = helper.query("calstatus", new QFilter[]{filter})) {
            dynamicObject.set("calstatus", (Object)CalStateEnum.WAIT_APPROVALED.getCode());
        }
        helper.save(queryResults);
    }

    private ApproveBillAccountDTO getApproveBillAccountDTO(String pageId) {
        ApproveBillAccountDTO cacheApproveBillAccountDTO = null;
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        IFormView view = sm.getView(pageId);
        if (view != null) {
            SWCPageCache pageCache = new SWCPageCache(view);
            cacheApproveBillAccountDTO = (ApproveBillAccountDTO)pageCache.get("LatestItemInfo", ApproveBillAccountDTO.class);
        }
        if (cacheApproveBillAccountDTO == null) {
            String viewEmptyOrNot = view == null ? "empty" : "not empty";
            log.error("CalApproveBillSaveOp.getApproveBillAccountDTO: cacheApproveBillAccountDTO is null, and view is {}.", (Object)viewEmptyOrNot);
        }
        return cacheApproveBillAccountDTO;
    }
}

