/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalApproveBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("caltasks");
        fieldKeys.add("approvebilltplv");
        fieldKeys.add("totalpersonnum");
        fieldKeys.add("totalsalaryfilenum");
        fieldKeys.add("calentryentity.calpersonid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        String source = "";
        if (this.operateOption.tryGetVariableValue("source", new RefObject())) {
            source = this.operateOption.getVariableValue("source");
        }
        if ("submit".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<Long> approveBillIdList = new ArrayList<Long>(10);
            ArrayList<Long> calTaskIdSet = new ArrayList<Long>(16);
            if (dataEntities.length == 1) {
                this.submitOneApproveBill(dataEntities, approveBillIdList, calTaskIdSet);
            } else {
                this.submitApproveBills(dataEntities, approveBillIdList, calTaskIdSet);
            }
            ArrayList<Long> calPersonIdList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : dataEntities) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("calentryentity");
                for (DynamicObject calEntryEntityDy : dynamicObjectCollection) {
                    Long calPersonId = calEntryEntityDy.getLong("calpersonid");
                    calPersonIdList.add(calPersonId);
                }
            }
            SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calperson");
            DynamicObject[] allCalPersons = calHelper.query("id,empnumber,name,caltask,calstatus,calresultid,onholdstatus,personhrv.id,salaryfile.id", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
            HashMap<Long, DynamicObject> calPersonMap = new HashMap<Long, DynamicObject>(calTaskIdSet.size());
            for (DynamicObject calPerson : allCalPersons) {
                calPersonMap.put(calPerson.getLong("id"), calPerson);
            }
            HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(16);
            ArrayList<DynamicObject> successApproveList = new ArrayList<DynamicObject>(dataEntities.length);
            for (DynamicObject approveBill : dataEntities) {
                DynamicObject calPerson;
                HashMap<Long, DynamicObject> updateAuditCalPerson = new HashMap<Long, DynamicObject>(16);
                HashSet<Long> personIdSet = new HashSet<Long>(16);
                HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
                DynamicObject approveBillTpl = approveBill.getDynamicObject("approvebilltplv");
                boolean isOnHold = ApproveBillService.getApproveBillTplIsOnHold((DynamicObject)approveBillTpl);
                DynamicObjectCollection dynamicObjectCollection = approveBill.getDynamicObjectCollection("calentryentity");
                Iterator iterator = dynamicObjectCollection.iterator();
                while (iterator.hasNext()) {
                    boolean isOnHoldError;
                    DynamicObject calEntryEntityDy = (DynamicObject)iterator.next();
                    Long calPersonId = calEntryEntityDy.getLong("calpersonid");
                    calPerson = (DynamicObject)calPersonMap.get(calPersonId);
                    boolean bl = isOnHoldError = SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), (String)calPerson.getString("onholdstatus")) || !isOnHold && SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), (String)calPerson.getString("onholdstatus"));
                    if (isOnHoldError) {
                        iterator.remove();
                        updateAuditCalPerson.put(calPersonId, calPerson);
                        continue;
                    }
                    long personId = calPerson.getLong("personhrv.id");
                    long salaryFileId = calPerson.getLong("salaryfile.id");
                    personIdSet.add(personId);
                    salaryFileIdSet.add(salaryFileId);
                }
                approveBill.set("totalpersonnum", (Object)personIdSet.size());
                approveBill.set("totalsalaryfilenum", (Object)salaryFileIdSet.size());
                if (!SWCStringUtils.equals((String)source, (String)"FormList")) continue;
                if (dynamicObjectCollection.size() == 0) {
                    ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo();
                    if (isOnHold) {
                        validationErrorInfo.setMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u4e2d\u6240\u6709\u6570\u636e\u7684\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u6b62\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279\u5355\u3002", (String)"CalApproveBillSubmitOp_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]), approveBill.getString("billno")));
                    } else {
                        validationErrorInfo.setMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u4e2d\u6240\u6709\u6570\u636e\u7684\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u505c\u201d\u6216\u201c\u6b62\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279\u5355\u3002", (String)"CalApproveBillSubmitOp_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), approveBill.getString("billno")));
                    }
                    validationErrorInfo.setPkValue(approveBill.getPkValue());
                    validationErrorInfo.setErrorLevel(ErrorLevel.Error.toString());
                    this.operationResult.addErrorInfo((OperateErrorInfo)validationErrorInfo);
                    this.operationResult.setShowMessage(true);
                    this.operationResult.setSuccess(false);
                    continue;
                }
                hashMap.putAll(updateAuditCalPerson);
                successApproveList.add(approveBill);
                for (Map.Entry longDynamicObjectEntry : updateAuditCalPerson.entrySet()) {
                    calPerson = (DynamicObject)longDynamicObjectEntry.getValue();
                    StringBuilder sb = new StringBuilder();
                    String personNumber = calPerson.getString("empnumber");
                    String personName = calPerson.getString("name");
                    sb.setLength(0);
                    sb.append(approveBill.getString("billno")).append('\uff1a').append(personName).append('(').append(personNumber).append(')');
                    if (isOnHold) {
                        sb.append(ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u56e0\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u6b62\u201d\uff0c\u7cfb\u7edf\u5df2\u4e3a\u60a8\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillSubmitOp_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                    } else {
                        sb.append(ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u56e0\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u505c\u201d\u6216\u201c\u6b62\u201d\uff0c\u7cfb\u7edf\u5df2\u4e3a\u60a8\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillSubmitOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                    }
                    ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo();
                    validationErrorInfo.setMessage(sb.toString());
                    validationErrorInfo.setPkValue(approveBill.getPkValue());
                    validationErrorInfo.setErrorLevel(ErrorLevel.Error.toString());
                    this.operationResult.addErrorInfo((OperateErrorInfo)validationErrorInfo);
                    this.operationResult.setShowMessage(true);
                }
            }
            if (SWCStringUtils.equals((String)source, (String)"FormList")) {
                DynamicObject[] successApproves = new DynamicObject[successApproveList.size()];
                args.setDataEntities(successApproveList.toArray(successApproves));
            }
            this.saveCalPersonStatus(calTaskIdSet, hashMap);
        }
    }

    protected void saveCalPersonStatus(List<Long> calTaskIdSet, Map<Long, DynamicObject> updateAuditCalPersons) {
        DynamicObject[] queryResults;
        HashMap unAuditCalPersonMap = new HashMap(16);
        HSASCalApproveBillHelper approveBillHelper = new HSASCalApproveBillHelper();
        Map calPersonMap = approveBillHelper.getNotPassCalPersonIds(calTaskIdSet, unAuditCalPersonMap);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", updateAuditCalPersons.keySet());
        for (DynamicObject cal : queryResults = helper.query("calstatus", new QFilter[]{filter})) {
            long id = cal.getLong("id");
            if (calPersonMap.containsKey(id) && !unAuditCalPersonMap.containsKey(id)) {
                cal.set("calstatus", (Object)CalStateEnum.APPROVALED_NOT_PASS.getCode());
                continue;
            }
            cal.set("calstatus", (Object)CalStateEnum.AUDIT.getCode());
        }
        helper.save(queryResults);
    }

    protected void submitOneApproveBill(DynamicObject[] dataEntities, List<Long> approveBillIdList, List<Long> calTaskIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        DynamicObject dataEntity = dataEntities[0];
        long id = dataEntity.getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = helper.queryOne("id,billstatus", new QFilter[]{filter});
        String billStatus = dynamicObject.getString("billstatus");
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            Long approveBillId = dataEntity.getLong("id");
            approveBillIdList.add(approveBillId);
            calTaskIdSet.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dataEntity));
        }
    }

    protected void submitApproveBills(DynamicObject[] dataEntities, List<Long> approveBillIdList, List<Long> calTaskIdSet) {
        for (DynamicObject dataEntity : dataEntities) {
            String billStatus = dataEntity.getString("billstatus");
            if (!"A".equals(billStatus) && !"G".equals(billStatus)) continue;
            Long approveBillId = dataEntity.getLong("id");
            approveBillIdList.add(approveBillId);
            calTaskIdSet.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dataEntity));
        }
    }
}

