/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveUnsubmitBillValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class CalApproveBillUnsubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("caltasks");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalApproveUnsubmitBillValidator());
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("unsubmit".equals(operationKey)) {
            DynamicObject[] calPersonList;
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<Long> calTaskIdSet = new ArrayList<Long>(16);
            ArrayList<Long> approveBillIdList = new ArrayList<Long>();
            this.setApproveBillState(dataEntities, approveBillIdList, calTaskIdSet);
            SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_calperson");
            HSASCalApproveBillHelper helper = new HSASCalApproveBillHelper();
            for (DynamicObject calPerson : calPersonList = helper.getNeedUpdateCalPersonList(approveBillIdList, calHelper)) {
                calPerson.set("calstatus", (Object)CalStateEnum.WAIT_APPROVALED.getCode());
            }
            calHelper.update(calPersonList);
        }
    }

    protected void setApproveBillState(DynamicObject[] dataEntities, List<Long> approveBillIdList, List<Long> calTaskIdSet) {
        for (DynamicObject dataEntity : dataEntities) {
            Long approveBillId = dataEntity.getLong("id");
            approveBillIdList.add(approveBillId);
            calTaskIdSet.addAll(HSASCalApproveBillHelper.getCalTask((DynamicObject)dataEntity));
        }
    }
}

