/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.attbizdata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.common.utils.BizDataUniqueCodeUtils;
import kd.swc.hsas.opplugin.validator.attbizdata.AttBizDataSummaryValidator;
import kd.swc.hsas.opplugin.validator.attbizdata.AttBizDataValidator;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class AttBizDataSummarySaveOp
extends SWCDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(AttBizDataSummarySaveOp.class);
    private static final String CODE_PRE_FIX = "HSAS";

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("attbizitem");
        event.getFieldKeys().add("attbizitem.isminvalnull");
        event.getFieldKeys().add("attbizitem.ismaxvalnull");
        event.getFieldKeys().add("attbizitem.ctrlstrategy");
        event.getFieldKeys().add("attbizitem.datatype.id");
        event.getFieldKeys().add("attbizitem.scalelimit");
        event.getFieldKeys().add("employee");
        event.getFieldKeys().add("person");
        event.getFieldKeys().add("depemp");
        event.getFieldKeys().add("depemp.person.id");
        event.getFieldKeys().add("depemp.person.name");
        event.getFieldKeys().add("depemp.employee.id");
        event.getFieldKeys().add("adminorg");
        event.getFieldKeys().add("bizuniquecode");
        event.getFieldKeys().add("attstartdate");
        event.getFieldKeys().add("attenddate");
        event.getFieldKeys().add("currency");
        event.getFieldKeys().add("currency.amtprecision");
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("datasource");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("nocounttimes");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new AttBizDataValidator());
        event.addValidator((AbstractValidator)new AttBizDataSummaryValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        String operationKey = event.getOperationKey();
        DynamicObject[] dataEntities = event.getDataEntities();
        if (dataEntities.length <= 0) {
            return;
        }
        Map variables = this.getOption().getVariables();
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            if ("submit".equals(operationKey) && (!this.getOption().containsVariable("isListOp") || Boolean.TRUE.toString().equals(variables.get("isListOp")))) {
                return;
            }
            List bizDataCodeList = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{CODE_PRE_FIX, dataEntities.length});
            for (int index = 0; index < dataEntities.length; ++index) {
                DynamicObject dataEntity = dataEntities[index];
                String identifynumber = dataEntity.getString("identifynumber");
                if (SWCStringUtils.isEmpty((String)identifynumber)) {
                    identifynumber = (String)bizDataCodeList.get(index);
                    dataEntity.set("identifynumber", (Object)identifynumber);
                }
                long attBizItemId = dataEntity.getLong("attbizitem.id");
                String bizuniquecode = dataEntity.getString("bizuniquecode");
                if (attBizItemId != 0L && SWCStringUtils.isEmpty((String)bizuniquecode)) {
                    dataEntity.set("bizuniquecode", (Object)BizDataUniqueCodeUtils.getBizDataUniqueCode((String)identifynumber, (Long)attBizItemId));
                }
                dataEntity.set("person", dataEntity.get("depemp.person.id"));
                dataEntity.set("empnumber", dataEntity.get("employee.empnumber"));
            }
            this.doSaveAttBizData(dataEntities);
            this.formateDate(dataEntities);
        }
    }

    private void formateDate(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date attStartDate = dynamicObject.getDate("attstartdate");
            Date attEndDate = dynamicObject.getDate("attenddate");
            if (attStartDate != null) {
                try {
                    attStartDate = SWCDateTimeUtils.formatDateToDate((Date)attStartDate, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    LOGGER.error("AttBizDataSaveOp attStartDate formate error!");
                }
                dynamicObject.set("attstartdate", (Object)attStartDate);
            }
            if (attEndDate == null) continue;
            try {
                attEndDate = SWCDateTimeUtils.formatDateToDate((Date)attEndDate, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOGGER.error("AttBizDataSaveOp attEndDate formate error!");
            }
            dynamicObject.set("attenddate", (Object)attEndDate);
        }
    }

    private void doSaveAttBizData(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            DynamicObject bizItem = data.getDynamicObject("attbizitem");
            if (SWCStringUtils.isEmpty((String)data.getString("datasource"))) {
                data.set("datasource", (Object)"1");
            }
            boolean isImport = this.getOption().containsVariable("importtype");
            String isListOp = null;
            if (this.getOption().containsVariable("isListOp")) {
                isListOp = (String)this.getOption().getVariables().get("isListOp");
            }
            this.setSaveData(data, bizItem, isImport, isListOp);
        }
    }

    private void setSaveData(DynamicObject data, DynamicObject attBizItem, boolean isImport, String isListOp) {
        if (attBizItem == null) {
            return;
        }
        String textValue = null;
        Comparable<Date> value = null;
        long dataTypeId = attBizItem.getLong("datatype.id");
        if (!isImport && isListOp != null && StringUtils.equals((CharSequence)isListOp, (CharSequence)Boolean.FALSE.toString())) {
            if (dataTypeId == 1030L) {
                textValue = data.getString("inputtextvalue");
            } else if (dataTypeId == 1050L) {
                value = data.getDate("inputdatevalue");
                data.set("datevalue", (Object)value);
                textValue = SWCDateTimeUtils.format((Date)value, (String)"yyyy-MM-dd");
            } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
                value = data.getBigDecimal("inputdecimalvalue");
                Object scalelimit = attBizItem.get("scalelimit");
                if (dataTypeId == 1020L) {
                    scalelimit = data.getInt("currency.amtprecision");
                }
                int scale = 10;
                if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                    scale = Integer.parseInt(String.valueOf(scalelimit));
                }
                value = ((BigDecimal)value).setScale(scale, RoundingMode.HALF_UP);
                if (dataTypeId == 1020L) {
                    data.set("amountvalue", (Object)value);
                } else {
                    data.set("decimalvalue", (Object)value);
                }
                textValue = ((BigDecimal)value).toPlainString();
            }
            data.set("textvalue", (Object)textValue);
        } else if (isImport) {
            textValue = data.getString("inputtextvalue");
            if (dataTypeId == 1050L) {
                try {
                    value = SWCDateTimeUtils.parseDate((String)textValue, (String)"yyyy-MM-dd");
                }
                catch (Exception exception) {
                    LOGGER.error("parse date value error", (Throwable)exception);
                    value = new Date();
                }
                data.set("datevalue", (Object)value);
            } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
                value = new BigDecimal(textValue);
                Object scalelimit = attBizItem.get("scalelimit");
                int scale = 10;
                if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                    scale = Integer.parseInt(String.valueOf(scalelimit));
                }
                if (dataTypeId == 1020L) {
                    scale = data.getInt("currency.amtprecision");
                }
                value = ((BigDecimal)value).setScale(scale, RoundingMode.HALF_UP);
                if (dataTypeId == 1020L) {
                    data.set("amountvalue", (Object)value);
                } else {
                    data.set("decimalvalue", (Object)value);
                }
                textValue = ((BigDecimal)value).toPlainString();
            }
            data.set("textvalue", (Object)textValue);
        }
    }
}

