/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bankoffer;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.opplugin.validator.bankoffer.BankOfferLogInvalidValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferLogInvalidOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("isfailure");
        fieldKeys.add("failurereason");
        fieldKeys.add("creator");
        fieldKeys.add("failuretime");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BankOfferLogInvalidValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        HashSet payDetailLogIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        String invalidReason = (String)variables.get("text");
        for (DynamicObject entity : dataEntities) {
            Long id = entity.getLong("id");
            entity.set("isfailure", (Object)Boolean.TRUE);
            entity.set("failurereason", (Object)invalidReason);
            entity.set("failuretime", (Object)new Date());
            payDetailLogIds.add(id);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankreportlog");
        helper.update(dataEntities);
        this.setPayDetailInvalidByLogId(payDetailLogIds, invalidReason);
    }

    private void setPayDetailInvalidByLogId(Set<Long> payDetailLogIds, String invalidReason) {
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("bankofferlog", "in", payDetailLogIds);
        filter.and(new QFilter("bankofferstatus", "!=", (Object)BankOfferEnum.INVALIDED.getCode()));
        filter.and(new QFilter("abandonedstatus", "=", (Object)"0"));
        filter.and(new QFilter("paystate", "=", (Object)PayStateEnum.UNPAY.getCode()));
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "calpersonid,bankofferlog,bankofferstatus,bankofferfailureres";
        DynamicObject[] payDetails = detailHelper.query(selectProperties, filters);
        HashSet<Long> calTableIds = new HashSet<Long>(payDetails.length);
        invalidReason = invalidReason + " ";
        invalidReason = invalidReason + SWCDateTimeUtils.format((Date)new Date());
        for (DynamicObject payDetail : payDetails) {
            long bankOfferLogId = payDetail.getLong("bankofferlog.id");
            if (!payDetailLogIds.contains(bankOfferLogId)) continue;
            String objInvalidReason = payDetail.getString("bankofferfailureres");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(invalidReason);
            if (SWCStringUtils.isNotEmpty((String)objInvalidReason)) {
                stringBuilder.append("; ");
                stringBuilder.append(objInvalidReason);
            }
            String invalidAllReason = stringBuilder.toString();
            payDetail.set("bankofferstatus", (Object)BankOfferEnum.INVALIDED.getCode());
            payDetail.set("bankofferfailureres", (Object)invalidAllReason);
            calTableIds.add(payDetail.getLong("calpersonid"));
        }
        detailHelper.update(payDetails);
        AgencyPayWriteBackService service = new AgencyPayWriteBackService();
        service.updateCaltablePayState(calTableIds);
    }
}

