/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bankoffer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackHelper;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaydetailBankOfferInvalidOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("paystate");
        fieldKeys.add("bankofferstatus");
        fieldKeys.add("abandonedstatus");
        fieldKeys.add("bankofferfailureres");
        fieldKeys.add("caltableid");
        fieldKeys.add("calpersonid");
        fieldKeys.add("bankofferlog");
        fieldKeys.add("agencypaybill");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            if (!this.getBankOfferInvalidByIds(dataEntity)) continue;
            passDataEntitys.add(dataEntity);
        }
        e.getValidExtDataEntities().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getValidExtDataEntities().addAll(passDataEntitys);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String invalidReason;
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        HashSet calPersonIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet payDetailLogIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Set<Long> agencyIds = Arrays.stream(dataEntities).map(obj -> obj.getLong("agencypaybill.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> detailIdAndAgencyEntryMap = this.queryAgencyByDetailIds(agencyIds);
        if (detailIdAndAgencyEntryMap == null) {
            detailIdAndAgencyEntryMap = new HashMap<Long, DynamicObject>(0);
        }
        if (SWCStringUtils.isNotEmpty((String)(invalidReason = (String)variables.get("invalidReason")))) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            invalidReason = invalidReason + " ";
            invalidReason = invalidReason + SWCDateTimeUtils.format((Date)new Date());
            for (DynamicObject dynamicObject : dataEntities) {
                String objInvalidReason = dynamicObject.getString("bankofferfailureres");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(invalidReason);
                if (SWCStringUtils.isNotEmpty((String)objInvalidReason)) {
                    stringBuilder.append("; ");
                    stringBuilder.append(objInvalidReason);
                }
                String invalidAllReason = stringBuilder.toString();
                dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.INVALIDED.getCode());
                dynamicObject.set("bankofferfailureres", (Object)invalidAllReason);
                Long calPkid = dynamicObject.getLong("calpersonid");
                long id = dynamicObject.getLong("bankofferlog.id");
                calPersonIds.add(calPkid);
                payDetailLogIds.add(id);
                DynamicObject agencyDyn = detailIdAndAgencyEntryMap.get(dynamicObject.getLong("id"));
                if (agencyDyn == null) continue;
                dynamicObject.set("paystate", (Object)AgentPayResultWriteBackHelper.getDetailPayState((String)agencyDyn.getString("paystate")));
            }
            helper.update(dataEntities);
            AgencyPayWriteBackService service = new AgencyPayWriteBackService();
            service.updateCaltablePayState((Set)calPersonIds);
        }
    }

    private Map<Long, DynamicObject> queryAgencyByDetailIds(Set<Long> agencyIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsas_agencypaybill");
        String select = "id,entryentity,entryentity.paydetail,entryentity.paystate";
        QFilter filter = new QFilter("id", "in", agencyIds);
        DynamicObject[] query = serviceHelper.query(select, new QFilter[]{filter});
        if (query == null) {
            return null;
        }
        HashMap detailIdAndAgencyEntryMap = Maps.newHashMapWithExpectedSize((int)agencyIds.size());
        for (DynamicObject agencyDyn : query) {
            DynamicObjectCollection entry = agencyDyn.getDynamicObjectCollection("entryentity");
            entry.stream().forEach(obj -> detailIdAndAgencyEntryMap.put(obj.getLong("paydetail.id"), obj));
        }
        return detailIdAndAgencyEntryMap;
    }

    private boolean getBankOfferInvalidByIds(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String payState = dynamicObject.getString("paystate");
        String bankOfferStatus = dynamicObject.getString("bankofferstatus");
        Boolean abandonedStatus = dynamicObject.getBoolean("abandonedstatus");
        return !PayStateEnum.PAID.getCode().equals(payState) && BankOfferEnum.EXPORTED.getCode().equals(bankOfferStatus) && abandonedStatus == false;
    }
}

