/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.util.List;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.opplugin.validator.basedata.CalItemGroupAndCalRuleImportValidator;
import kd.swc.hsas.opplugin.validator.basedata.CalRuleAuditValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalRuleAuditOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("datasource");
        fieldKeys.add("calruleitementry");
        fieldKeys.add("formula");
        fieldKeys.add("ispayoutitem");
        fieldKeys.add("salaryitem");
        fieldKeys.add("isconvert");
        fieldKeys.add("customprorationrule");
        fieldKeys.add("allowresultcover");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalRuleAuditValidator());
        e.addValidator((AbstractValidator)new CalItemGroupAndCalRuleImportValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.showInteractionMessage(e, "confirmNoPayItem");
        if (this.getOption().containsVariable("confirmMsg")) {
            e.setCancel(!this.showInteractionMessage("confirmMsg"));
        }
        this.showInteractionMessage(e, "confirmTotalSalNoFormulaMsg");
        this.showInteractionMessage(e, "confirmNetSalNoFormulaMsg");
        this.showInteractionMessage(e, "confirmAllSalNoFormulaMsg");
    }

    private void showInteractionMessage(BeforeOperationArgs e, String messageKey) {
        if (this.getOption().containsVariable(messageKey) && !this.getOption().containsVariable(messageKey.concat("_finish"))) {
            e.setCancel(!this.showInteractionMessage(messageKey));
        }
    }

    private boolean showInteractionMessage(String messageKey) {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(this.getInteractionSponore())) {
            String result = (String)confirmResult.getResults().get(this.getInteractionSponore());
            this.getOption().setVariableValue("interactionconfirmresult", "");
            this.getOption().setVariableValue(messageKey + "_finish", "");
            return "Yes".equals(result);
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("hsbp_confirmdlg");
        interactionContext.getCustShowParameter().put("message", this.getOption().getVariableValue(messageKey));
        throw new KDInteractionException(this.getInteractionSponore(), interactionContext);
    }

    private String getInteractionSponore() {
        return "kd.swc.hsas.opplugin.web.basedata.CalRuleAuditOp";
    }
}

