/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class PayrollGroupAdaptionOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcevid");
        e.getFieldKeys().add("costadaption");
        e.getFieldKeys().add("hrorg");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        if (!CostHelper.isEnableCost()) {
            return;
        }
        DynamicObject[] payrollGroupObjs = e.getDataEntities();
        ArrayList<DynamicObject[]> payrollGroupIdList = new ArrayList<DynamicObject[]>(payrollGroupObjs.length);
        for (DynamicObject payrollGroupObj : payrollGroupObjs) {
            DynamicObject[] id = Long.valueOf(payrollGroupObj.getLong("id"));
            if (id.longValue() == 0L) continue;
            payrollGroupIdList.add(id);
        }
        SWCDataServiceHelper payrollGroupHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        QFilter qFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        qFilter.and(new QFilter("source", "in", payrollGroupIdList));
        DynamicObject[] costAdaptionMapObjArr = payrollGroupHelper.query("status,source,costadaption,modifytime,modifier,hrorg", new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> costAdaptionMap = new HashMap<Long, DynamicObject>(costAdaptionMapObjArr.length);
        for (DynamicObject costAdaptionMapObj : costAdaptionMapObjArr) {
            costAdaptionMap.put(costAdaptionMapObj.getLong("source"), costAdaptionMapObj);
        }
        switch (operationKey = e.getOperationKey()) {
            case "save": 
            case "unsubmit": {
                this.saveOrUpdateCostAdaptionInfo(payrollGroupObjs, costAdaptionMap, "A");
                break;
            }
            case "submit": 
            case "unaudit": {
                this.saveOrUpdateCostAdaptionInfo(payrollGroupObjs, costAdaptionMap, "B");
                break;
            }
            case "audit": {
                this.saveOrUpdateCostAdaptionInfo(payrollGroupObjs, costAdaptionMap, "C");
                break;
            }
        }
    }

    private void saveOrUpdateCostAdaptionInfo(DynamicObject[] payrollGroupObjs, Map<Long, DynamicObject> costAdaptionMap, String status) {
        DynamicObjectCollection payrollGroupObjColl = new DynamicObjectCollection();
        DynamicObjectCollection payrollGroupHisObjColl = new DynamicObjectCollection();
        Long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        SWCDataServiceHelper payrollGroupHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        for (DynamicObject payrollGroupObj : payrollGroupObjs) {
            Long payrollGroupObjId = payrollGroupObj.getLong("id");
            DynamicObject costAdaptionMappingObj = costAdaptionMap.get(payrollGroupObjId);
            if (costAdaptionMappingObj == null) {
                costAdaptionMappingObj = this.generateCostAdaptionMapObj();
                costAdaptionMappingObj.set("source", (Object)payrollGroupObjId);
            }
            long costAdaptionId = payrollGroupObj.getLong("costadaption.id");
            long hrOrgId = payrollGroupObj.getLong("hrorg.id");
            if (costAdaptionId == 0L || hrOrgId == 0L) {
                costAdaptionId = costAdaptionMappingObj.getLong("costadaption.id");
                hrOrgId = costAdaptionMappingObj.getLong("hrorg.id");
            }
            if ("C".equals(status)) {
                long vId = payrollGroupObj.getLong("sourcevid");
                DynamicObject costAdaptionHisMappingObj = this.generateCostAdaptionMapObj();
                costAdaptionHisMappingObj.set("source", (Object)vId);
                costAdaptionHisMappingObj.set("costadaption", (Object)costAdaptionId);
                costAdaptionHisMappingObj.set("hrorg", (Object)hrOrgId);
                costAdaptionHisMappingObj.set("status", (Object)"C");
                payrollGroupHisObjColl.add((Object)costAdaptionHisMappingObj);
            }
            costAdaptionMappingObj.set("costadaption", (Object)costAdaptionId);
            costAdaptionMappingObj.set("hrorg", (Object)hrOrgId);
            costAdaptionMappingObj.set("status", (Object)status);
            costAdaptionMappingObj.set("modifytime", (Object)currentDate);
            costAdaptionMappingObj.set("modifier", (Object)userId);
            payrollGroupObjColl.add((Object)costAdaptionMappingObj);
        }
        payrollGroupHelper.save(payrollGroupObjColl);
        payrollGroupHelper.save(payrollGroupHisObjColl);
    }

    private DynamicObject generateCostAdaptionMapObj() {
        SWCDataServiceHelper payrollGroupHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        DynamicObject costAdaptionMappingObj = payrollGroupHelper.generateEmptyDynamicObject();
        Long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        costAdaptionMappingObj.set("createtime", (Object)currentDate);
        costAdaptionMappingObj.set("creator", (Object)userId);
        costAdaptionMappingObj.set("modifier", (Object)userId);
        costAdaptionMappingObj.set("modifytime", (Object)currentDate);
        costAdaptionMappingObj.set("mapobj", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        return costAdaptionMappingObj;
    }
}

