/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.payrollgrp.helper.PayRollGrpHelper;
import kd.swc.hsas.opplugin.validator.payrollgroup.PayrollGroupSaveValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class PayrollGroupSaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("payrollscene.id");
        fieldKeys.add("callistview.id");
        fieldKeys.add("payrollsceneentry.seq");
        fieldKeys.add("issalaryslipsum");
        fieldKeys.add("payrollgrpmulsum");
        fieldKeys.add("prorationcal");
        fieldKeys.add("prorationgenrule");
        fieldKeys.add("payrollsceneentry.lssuepayslip");
        fieldKeys.add("payrollsceneentry.releasesalaryslip");
        fieldKeys.add("payrollsceneentry.salaryslipview");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Set payRollGrpIdSet;
                List auditPayRollGrpIdList;
                if ("hsas_payrollgrp".equals(this.getEntityKey()) && !(auditPayRollGrpIdList = PayRollGrpHelper.queryAuditPayrollGrpIdList(payRollGrpIdSet = Arrays.stream(this.getDataEntities()).map(entity -> Long.parseLong(String.valueOf(entity.getDataEntity().getPkValue()))).collect(Collectors.toSet()))).isEmpty()) {
                    this.dataEntities = (ExtendedDataEntity[])Arrays.stream(this.dataEntities).filter(entity -> !auditPayRollGrpIdList.contains(entity.getDataEntity().getPkValue())).toArray(ExtendedDataEntity[]::new);
                }
            }
        });
        e.addValidator((AbstractValidator)new PayrollGroupSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Arrays.stream(dataEntities).flatMap(dataEntity -> dataEntity.getDynamicObjectCollection("payrollsceneentry").stream()).filter(entry -> !"1".equals(entry.getString("lssuepayslip"))).forEach(entry -> {
            entry.set("releasesalaryslip", null);
            entry.set("salaryslipview", null);
        });
    }
}

