/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.business.personchange.PersonChangeService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataRecordAuditStateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataAbandonOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(BizDataAbandonOp.class);
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("opreason");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("bizitem.id");
        String isRecur = this.getOption().getVariableValue("isRecur");
        if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
            event.getFieldKeys().add("salaryadjustrsn");
            event.getFieldKeys().add("action");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        this.saveBizDataModifyRecord(event.getDataEntities());
        this.doBizDataAbandon(event);
    }

    private void saveBizDataModifyRecord(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("opreason", " ");
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemId(Long.valueOf(data.getLong("bizitem.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.AUDITSTATUS.getCode());
            dataModifyRec.setBeforeUpdate(BizDataRecordAuditStateEnum.getDesc((String)data.getString("auditstatus")));
            dataModifyRec.setAfterUpdate(BizDataRecordAuditStateEnum.OBSOLETE.getDesc());
            dataModifyRec.setDescription(description);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_ABANDON.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("1");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }

    private void doBizDataAbandon(BeginOperationTransactionArgs event) {
        String operationKey = event.getOperationKey();
        PersonChangeService dataEntities = event.getDataEntities();
        String opReason = this.getOption().getVariableValue("opreason");
        String isRecur = this.getOption().getVariableValue("isRecur");
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        List abandonIdList = (List)appCache.get("abandonIdList", List.class);
        appCache.remove(HSAS_BIZDATA_CACHE_KEY);
        long userId = RequestContext.get().getCurrUserId();
        if (SWCStringUtils.equals((String)"donothing_abandon", (String)operationKey)) {
            if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
                ArrayList personChangeList = new ArrayList(10);
                for (DynamicObject data : dataEntities) {
                    long salaryadjustrsn = data.getLong("salaryadjustrsn.id");
                    long action = data.getLong("action.id");
                    if (salaryadjustrsn == 0L && action == 0L) continue;
                    HashMap<String, Number> personChangeMap = new HashMap<String, Number>(3);
                    personChangeMap.put("bizDataId", data.getLong("id"));
                    personChangeMap.put("cycle", 1);
                    personChangeList.add(personChangeMap);
                }
                if (personChangeList.size() > 0) {
                    PersonChangeService personChangeService = new PersonChangeService();
                    personChangeService.abandonPersonChange("2", personChangeList);
                }
            }
            ArrayList abandonBizDataList = new ArrayList(((DynamicObject[])dataEntities).length);
            for (DynamicObject data : dataEntities) {
                if (!abandonIdList.contains(data.getLong("id"))) continue;
                data.set("auditstatus", (Object)"F");
                data.set("opreason", (Object)opReason);
                data.set("modifier", (Object)userId);
                data.set("modifytime", (Object)new Date());
                String dataSources = data.getString("datasources");
                if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
                HashMap<String, Object> abandonBizDataMap = new HashMap<String, Object>(16);
                abandonBizDataMap.put("bizdatacode", data.getString("identifynumber"));
                abandonBizDataMap.put("bizitem", data.getLong("bizitem.id"));
                abandonBizDataMap.put("salaryfile", data.getLong("salaryfile.id"));
                abandonBizDataMap.put("modeltype", "1");
                abandonBizDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_ABANDON.getCode());
                abandonBizDataMap.put("status", BizDataStatusEnum.HSAS_DISABLED.getCode());
                abandonBizDataMap.put("description", opReason);
                abandonBizDataMap.put("modifier", userId);
                abandonBizDataList.add(abandonBizDataMap);
            }
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
            if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
                bizDataHelper.setEntityName("hsas_recurbizdata");
            }
            bizDataHelper.update((DynamicObject[])dataEntities);
            if (abandonBizDataList.size() > 0) {
                Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{abandonBizDataList});
                log.info("BizDataAbandonOp result is:{}", (Object)result);
            }
        }
    }
}

