/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataRecordValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataRecordUpdateBsedOp
extends SWCDataBaseOp {
    public static final Log log = LogFactory.getLog(BizDataRecordUpdateBsedOp.class);
    private static final int batchQuerySize = 500;

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("updatetimes");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("id");
        event.getFieldKeys().add("salaryfile");
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("usagecount");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataRecordValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long currentTime = System.currentTimeMillis();
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        log.info("BizDataRecordUpdateBsedOp batch size is: {}", (Object)dataEntities.length);
        switch (operationKey) {
            case "donothing_updatebsed": {
                long startTime = System.currentTimeMillis();
                this.updateBsedAndUpdateTimes(dataEntities);
                log.info("BizDataRecordUpdateBsedOp beginOperationTransaction total use time: {}", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
        }
        log.info("BizDataRecordUpdateBsedOp total use time: {}", (Object)(System.currentTimeMillis() - currentTime));
    }

    private void updateBsedAndUpdateTimes(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("description");
        String updatebsed = this.getOption().getVariableValue("updatebsed");
        Date updateDate = null;
        String afterUpdate = null;
        try {
            updateDate = SWCDateTimeUtils.parseDate((String)updatebsed);
            afterUpdate = SWCDateTimeUtils.format((Date)updateDate, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            log.info(e.toString());
        }
        String bizItemGroup = this.getOption().getVariableValue("bizitemgroup");
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> modifyRecordList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<Long> recordIdList = new ArrayList<Long>(dataEntities.length);
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"hsas_bizdatamodifyrecord");
        for (DynamicObject data : dataEntities) {
            String beforeUpdateBsed = SWCDateTimeUtils.format((Date)data.getDate("bsed"), (String)"yyyy-MM-dd");
            DynamicObject dyn = (DynamicObject)objType.createInstance();
            dyn.set("salaryfile", data.get("salaryfile"));
            dyn.set("bizdatanum", data.get("identifynumber"));
            dyn.set("updatefield", (Object)BizDataUpdateFieldEnum.BSED.getCode());
            dyn.set("beforeupdate", (Object)beforeUpdateBsed);
            dyn.set("afterupdate", (Object)afterUpdate);
            dyn.set("description", (Object)description);
            dyn.set("datasources", data.get("datasources"));
            dyn.set("modifier", (Object)userId);
            dyn.set("modifytime", (Object)date);
            dyn.set("operate", (Object)BizDataOperateEnum.OPERATE_UPDATEBSED.getCode());
            dyn.set("dataid", (Object)data.getLong("id"));
            dyn.set("modeltype", (Object)2);
            dyn.set("creator", (Object)userId);
            dyn.set("createtime", (Object)date);
            dyn.set("bizitemgroup", (Object)Long.parseLong(bizItemGroup));
            modifyRecordList.add(dyn);
            data.set("bsed", (Object)updateDate);
            data.set("updatetimes", (Object)(data.getInt("updatetimes") + 1));
            data.set("modifier", (Object)userId);
            data.set("modifytime", (Object)date);
            recordIdList.add(data.getLong("id"));
        }
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        bizDataHelper.update(dataEntities);
        bizDataHelper.setEntityName("hsas_bizdatamodifyrecord");
        bizDataHelper.save(modifyRecordList.toArray(new DynamicObject[modifyRecordList.size()]));
        if (recordIdList != null && recordIdList.size() > 0) {
            log.info("BizDataRecordRejectOp updatebsed recordId size is:{}", (Object)recordIdList.size());
            this.updateBsedNonrecurData(recordIdList, updateDate, userId, date);
        }
    }

    private void updateBsedNonrecurData(List<Long> recordIdList, Date updateDate, long userId, Date currentDate) {
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(500);
        for (Long bizDataRecordId : recordIdList) {
            bizDataRecordIdSet.add(bizDataRecordId);
            if (bizDataRecordIdSet.size() != 500) continue;
            long startTime = System.currentTimeMillis();
            this.updateNonBizData(bizDataRecordIdSet, dataHelper, updateDate, userId, currentDate);
            log.info("BizDataRecordRejectOp updateBsedNonrecurData cycle use time:{}", (Object)(System.currentTimeMillis() - startTime));
            bizDataRecordIdSet.clear();
        }
        long startTime = System.currentTimeMillis();
        if (bizDataRecordIdSet != null && bizDataRecordIdSet.size() > 0) {
            this.updateNonBizData(bizDataRecordIdSet, dataHelper, updateDate, userId, currentDate);
        }
        log.info("BizDataRecordRejectOp updateBsedNonrecurData use time:{}, size:{}", (Object)(System.currentTimeMillis() - startTime), (Object)bizDataRecordIdSet.size());
    }

    private void updateNonBizData(Set<Long> bizDataRecordIdSet, SWCDataServiceHelper dataHelper, Date updateDate, long userId, Date currentDate) {
        QFilter filter = new QFilter("bizdatarecord", "in", bizDataRecordIdSet);
        DynamicObject[] nonRecurDatas = dataHelper.query("salaryfile, bsed, modifier, modifytime", new QFilter[]{filter});
        if (nonRecurDatas == null || nonRecurDatas.length == 0) {
            return;
        }
        for (DynamicObject nonRecurObj : nonRecurDatas) {
            nonRecurObj.set("bsed", (Object)updateDate);
            nonRecurObj.set("modifier", (Object)userId);
            nonRecurObj.set("modifytime", (Object)currentDate);
        }
        dataHelper.update(nonRecurDatas);
    }
}

