/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.common.utils.BizDataUniqueCodeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataTplSaveOp
extends SWCDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(BizDataTplSaveOp.class);
    private static final String CODE_PRE_FIX = "HSAS";

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("identifynumber");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        String operationKey = event.getOperationKey();
        if ("save".equals(operationKey)) {
            long startTime = System.currentTimeMillis();
            DynamicObject[] dataEntities = event.getDataEntities();
            if (dataEntities.length <= 0) {
                return;
            }
            LOGGER.info("BizDataTplSaveOp getBizDataCodes size:{}", (Object)dataEntities.length);
            List bizDataCodeList = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{CODE_PRE_FIX, dataEntities.length});
            for (int index = 0; index < dataEntities.length; ++index) {
                DynamicObject dataEntity = dataEntities[index];
                String identifynumber = dataEntity.getString("identifynumber");
                if (SWCStringUtils.isEmpty((String)identifynumber)) {
                    identifynumber = (String)bizDataCodeList.get(index);
                    dataEntity.set("identifynumber", (Object)identifynumber);
                }
                long bizItemId = dataEntity.getLong("bizitem.id");
                String bizuniquecode = dataEntity.getString("bizuniquecode");
                if (bizItemId == 0L || !SWCStringUtils.isEmpty((String)bizuniquecode)) continue;
                dataEntity.set("bizuniquecode", (Object)BizDataUniqueCodeUtils.getBizDataUniqueCode((String)identifynumber, (Long)bizItemId));
            }
            LOGGER.info("BizDataTplSaveOp getBizDataCodes use time:{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }
}

