/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataUpdateBsledOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(BizDataUpdateBsledOp.class);
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("bizitem.id");
        event.getFieldKeys().add("datasources");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        this.saveBizDataModifyRecord(event.getDataEntities());
        this.saveBizDataBsledRecord(event.getDataEntities());
    }

    private void saveBizDataModifyRecord(DynamicObject[] dataEntities) {
        String descriptionbsled = this.getOption().getVariableValue("descriptionbsled", null);
        String updatebsledStr = this.getOption().getVariableValue("updatebsledStr", null);
        if (updatebsledStr == null) {
            return;
        }
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemId(Long.valueOf(data.getLong("bizitem.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            Date bsled = data.getDate("bsled");
            String beforeUpdateBsled = bsled != null ? SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd") : " ";
            dataModifyRec.setBeforeUpdate(beforeUpdateBsled);
            dataModifyRec.setAfterUpdate(updatebsledStr);
            dataModifyRec.setDescription(descriptionbsled);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("1");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }

    private void saveBizDataBsledRecord(DynamicObject[] dataEntities) {
        String descriptionbsled = this.getOption().getVariableValue("descriptionbsled", null);
        String isRecur = this.getOption().getVariableValue("isRecur");
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        List updateIdList = (List)appCache.get("updateBsledIdList", List.class);
        Date updateBsled = (Date)appCache.get("updatebsled", Date.class);
        appCache.remove(HSAS_BIZDATA_CACHE_KEY);
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<DynamicObject> bizDataBsledRecordList = new ArrayList<DynamicObject>(10);
        ArrayList updateBizDataList = new ArrayList(10);
        SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        for (DynamicObject data : dataEntities) {
            if (!updateIdList.contains(data.getLong("id"))) continue;
            DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
            Long updateSalaryFileId = data.getLong("salaryfile.id");
            bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
            Long oldBizItemId = data.getLong("bizitem.id");
            bsledRecordObj.set("bizitem", (Object)oldBizItemId);
            String bizDataCode = data.getString("identifynumber");
            bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
            bsledRecordObj.set("opbizdatacode", (Object)bizDataCode);
            bsledRecordObj.set("beforebsled", (Object)data.getDate("bsled"));
            bsledRecordObj.set("afterbsled", (Object)updateBsled);
            bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            bsledRecordObj.set("modifier", (Object)userId);
            Date modifytime = new Date();
            bsledRecordObj.set("modifytime", (Object)modifytime);
            bizDataBsledRecordList.add(bsledRecordObj);
            data.set("bsled", (Object)updateBsled);
            data.set("modifier", (Object)userId);
            data.set("modifytime", (Object)modifytime);
            String dataSources = data.getString("datasources");
            if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
            HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
            updateBizDataMap.put("bizdatacode", bizDataCode);
            updateBizDataMap.put("bizitem", oldBizItemId);
            updateBizDataMap.put("salaryfile", updateSalaryFileId);
            updateBizDataMap.put("modeltype", "1");
            updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            updateBizDataMap.put("bsled", updateBsled);
            updateBizDataMap.put("modifier", userId);
            updateBizDataMap.put("description", descriptionbsled);
            updateBizDataList.add(updateBizDataMap);
        }
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
            bizDataHelper.setEntityName("hsas_recurbizdata");
            if (bizDataBsledRecordList != null && bizDataBsledRecordList.size() > 0) {
                bsledRecordHelper.save(bizDataBsledRecordList.toArray(new DynamicObject[bizDataBsledRecordList.size()]));
            }
        }
        bizDataHelper.update(dataEntities);
        if (updateBizDataList.size() > 0) {
            Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
            log.info("BizDataUpdateBsledOp IHPDIBizDataService result is:{}", (Object)result);
        }
    }
}

