/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataValidator;
import kd.swc.hsas.opplugin.validator.bizdatatpl.NonRecurBizDataValidator;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class NonRecurBizDataSaveOp
extends SWCDataBaseOp {
    public static final Log log = LogFactory.getLog(NonRecurBizDataSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("bizitem.isminvalnull");
        event.getFieldKeys().add("bizitem.ismaxvalnull");
        event.getFieldKeys().add("bizitem.ctrlstrategy");
        event.getFieldKeys().add("salaryfile.person");
        event.getFieldKeys().add("salaryfile.org");
        event.getFieldKeys().add("salaryfile.payrollregion");
        event.getFieldKeys().add("salaryfile.payrollgroup");
        event.getFieldKeys().add("salaryfile.adminorg");
        event.getFieldKeys().add("salaryfile.empgroup");
        event.getFieldKeys().add("calperiodtype");
        event.getFieldKeys().add("calperiod");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("datavalue");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("decimalvalue");
        event.getFieldKeys().add("datevalue");
        event.getFieldKeys().add("currency");
        event.getFieldKeys().add("currency.amtprecision");
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("org");
        event.getFieldKeys().add("payrollregion");
        event.getFieldKeys().add("payrollgroup");
        event.getFieldKeys().add("adminorg");
        event.getFieldKeys().add("empgroup");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        log.info("start validate nonrecurbizdata,time:{}", (Object)System.currentTimeMillis());
        event.addValidator((AbstractValidator)new NonRecurBizDataValidator());
        event.addValidator((AbstractValidator)new BizDataValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        String operationKey = event.getOperationKey();
        DynamicObject[] dataEntities = event.getDataEntities();
        switch (operationKey) {
            case "save": 
            case "submit": {
                log.info("start save nonrecurbizdata,time:{}", (Object)System.currentTimeMillis());
                this.doSaveBizData(dataEntities);
                DynamicObject[] dynamicObjects = event.getDataEntities();
                this.formateDate(dynamicObjects);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs event) {
        log.info("after execute nonrecurbizdata,time:{}", (Object)System.currentTimeMillis());
    }

    private void formateDate(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date bsed = dynamicObject.getDate("bsed");
            if (bsed == null) continue;
            try {
                bsed = SWCDateTimeUtils.formatDateToDate((Date)bsed, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                log.info("NonrecurbizDataSaveOp bsed formate error!");
            }
            dynamicObject.set("bsed", (Object)bsed);
        }
    }

    private void doSaveBizData(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            DynamicObject bizItem = data.getDynamicObject("bizitem");
            if ("1".equals(data.getString("datasources")) || SWCStringUtils.isEmpty((String)data.getString("datasources"))) {
                data.set("datasources", (Object)"1");
            }
            String isImport = null;
            Map variables = this.getOption().getVariables();
            if (this.getOption().containsVariable("isImport")) {
                isImport = (String)variables.get("isImport");
            }
            String isListOp = null;
            if (this.getOption().containsVariable("isListOp")) {
                isListOp = (String)variables.get("isListOp");
            }
            this.setSaveData(data, bizItem, isImport, isListOp);
            data.set("org", data.get("salaryfile.org"));
            data.set("payrollregion", data.get("salaryfile.payrollregion"));
            data.set("payrollgroup", data.get("salaryfile.payrollgroup"));
            data.set("adminorg", data.get("salaryfile.adminorg"));
            data.set("empgroup", data.get("salaryfile.empgroup"));
        }
    }

    private void setSaveData(DynamicObject data, DynamicObject bizItem, String isImport, String isListOp) {
        String value = null;
        long dataTypeId = bizItem.getLong("datatype.id");
        if (isImport != null && StringUtils.equals((CharSequence)isImport, (CharSequence)Boolean.FALSE.toString()) && isListOp != null && StringUtils.equals((CharSequence)isListOp, (CharSequence)Boolean.FALSE.toString())) {
            if (dataTypeId == 1030L) {
                value = data.getString("datavalue");
            } else if (dataTypeId == 1050L) {
                value = SWCDateTimeUtils.format((Date)data.getDate("datevalue"), (String)"yyyy-MM-dd");
            } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
                value = data.getBigDecimal("decimalvalue").toPlainString();
                Object scalelimit = bizItem.get("scalelimit");
                if (dataTypeId == 1020L) {
                    scalelimit = data.getInt("currency.amtprecision");
                }
                int scale = 10;
                if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                    scale = Integer.parseInt(String.valueOf(scalelimit));
                }
                value = new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP).toPlainString();
            }
            data.set("datavalue", (Object)value);
        } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
            BigDecimal importValue = new BigDecimal(data.getString("datavalue"));
            Object scalelimit = bizItem.get("scalelimit");
            int scale = 10;
            if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                scale = Integer.parseInt(String.valueOf(scalelimit));
            }
            if (dataTypeId == 1020L) {
                scale = data.getInt("currency.amtprecision");
            }
            data.set("datavalue", (Object)importValue.setScale(scale, RoundingMode.HALF_UP).toPlainString());
        }
    }
}

