/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.opplugin.validator.bizdatatpl.NonRecurBizDataValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class NonRecurBizDataUpdateBsedOp
extends SWCDataBaseOp {
    public static final Log log = LogFactory.getLog(NonRecurBizDataUpdateBsedOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("updatetimes");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("id");
        event.getFieldKeys().add("salaryfile");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("auditstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new NonRecurBizDataValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long currentTime = System.currentTimeMillis();
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        log.info("NonRecurBizDataUpdateBsedOp batch size is:{}", (Object)dataEntities.length);
        switch (operationKey) {
            case "donothing_updatebsed": {
                long startTime = System.currentTimeMillis();
                this.updateBsedAndUpdateTimes(dataEntities);
                log.info("NonRecurBizDataUpdateBsedOp beginOperationTransaction total use time:{}", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
        }
        log.info("NonRecurBizDataUpdateBsedOp total use time:{}", (Object)(System.currentTimeMillis() - currentTime));
    }

    private void updateBsedAndUpdateTimes(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("description", null);
        String updatebsed = this.getOption().getVariableValue("updatebsed", null);
        if (updatebsed == null) {
            return;
        }
        Date updateDate = null;
        try {
            updateDate = SWCDateTimeUtils.parseDate((String)updatebsed);
        }
        catch (ParseException e) {
            log.info(e.toString());
        }
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemId(Long.valueOf(data.getLong("bizitem.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSED.getCode());
            String beforeUpdateBsed = SWCDateTimeUtils.format((Date)data.getDate("bsed"), (String)"yyyy-MM-dd");
            dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
            dataModifyRec.setAfterUpdate(updatebsed);
            dataModifyRec.setDescription(description);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_UPDATEBSED.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("1");
            dataModifyRecs.add(dataModifyRec);
            data.set("bsed", (Object)updateDate);
            data.set("updatetimes", (Object)(data.getInt("updatetimes") + 1));
            data.set("modifier", (Object)userId);
            data.set("modifytime", (Object)date);
        }
        long currentTime = System.currentTimeMillis();
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        bizDataHelper.update(dataEntities);
        long currentTime2 = System.currentTimeMillis();
        log.info("NonRecurBizDataUpdateBsedOp updata HSAS_NONRECURBIZDATA total use time:{}", (Object)(currentTime2 - currentTime));
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
        log.info("NonRecurBizDataUpdateBsedOp save record total use time:{}", (Object)(System.currentTimeMillis() - currentTime2));
    }
}

