/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataPayRollGrpTransValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class RecurBizDataPayRollGrpDirectTransOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(RecurBizDataPayRollGrpDirectTransOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("id");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("salaryfile.number");
        event.getFieldKeys().add("salaryfile.person.id");
        event.getFieldKeys().add("salaryfile.org.id");
        event.getFieldKeys().add("salaryfile.payrollregion.id");
        event.getFieldKeys().add("salaryfile.payrollgroup.id");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("bizdataaccesstpl.id");
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("bizitem.id");
        event.getFieldKeys().add("bizitem.name");
        event.getFieldKeys().add("bizitem.ctrlstrategy");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataPayRollGrpTransValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.dealBizDatas(dataEntities);
    }

    private void dealBizDatas(DynamicObject[] dataEntities) {
        HashSet<Long> personIdSet = new HashSet<Long>(dataEntities.length);
        ArrayList<DynamicObject> bizDataList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bizDataObj : dataEntities) {
            bizDataList.add(bizDataObj);
            personIdSet.add(bizDataObj.getLong("salaryfile.person.id"));
        }
        Map variables = this.getOption().getVariables();
        String payRollGrpIdStr = (String)variables.get("payRollGroupId");
        Long payRollGroupId = Long.parseLong(payRollGrpIdStr);
        BizDataHelper bizDataHelper = new BizDataHelper();
        Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(personIdSet, payRollGroupId);
        Collections.sort(bizDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date bsed2;
                Date bsed1 = o1.getDate("bsed");
                if (bsed1.before(bsed2 = o2.getDate("bsed"))) {
                    return -1;
                }
                if (bsed1.after(bsed2)) {
                    return 1;
                }
                return 0;
            }
        });
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(bizDataList.size());
        HashSet<Long> bizItemIdSet = new HashSet<Long>(bizDataList.size());
        for (DynamicObject bizDataObj : bizDataList) {
            Map salaryFileInfo;
            bizItemIdSet.add(bizDataObj.getLong("bizitem.id"));
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            if (personId == null || personId == 0L || (salaryFileInfo = (Map)salaryFileMap.get(String.valueOf(personId))) == null) continue;
            salaryFileIdSet.add((Long)salaryFileInfo.get("salaryFileId"));
        }
        Table recurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        ArrayList allUpdateBsledList = new ArrayList(10);
        ArrayList<DynamicObject> needSaveBsledRecordList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        ArrayList<BizDataModifyRecEntity> needSaveLogList = new ArrayList<BizDataModifyRecEntity>(dataEntities.length);
        ArrayList<Map<String, Object>> updateBizDataList = new ArrayList<Map<String, Object>>(dataEntities.length);
        for (DynamicObject bizDataObj : bizDataList) {
            Long salaryFileId;
            Map salaryFileInfo;
            Long bizItemId = bizDataObj.getLong("bizitem.id");
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            if (personId == null || personId == 0L || (salaryFileInfo = (Map)salaryFileMap.get(String.valueOf(personId))) == null || (salaryFileId = (Long)salaryFileInfo.get("salaryFileId")) == null) continue;
            List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
            Date bsed = bizDataObj.getDate("bsed");
            Date bsled = bizDataObj.getDate("bsled");
            String identifyNum = bizDataObj.getString("identifynumber");
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                for (DynamicObject dataObj : dynamicObjects) {
                    String oldBizDataCode = dataObj.getString("identifynumber");
                    Long oldBizItemId = dataObj.getLong("bizitem.id");
                    Date oldBsled = dataObj.getDate("bsled");
                    if (oldBsled == null) continue;
                    bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                }
                List errorIdentifyNumList = bizDataHelper.getUpdateBsledErrorList(bsed, bsled, dynamicObjects, identifyNum);
                if (errorIdentifyNumList.size() > 0) continue;
            }
            this.salaryFileChangeLog(needSaveLogList, bizDataObj, salaryFileMap);
            this.salaryFileChangeSendHpdi(updateBizDataList, bizDataObj, salaryFileMap);
            List needUpdateBsledList = bizDataHelper.dealNeedUpdateBsledData(recurBizData, salaryFileId, bizItemId, bsed, bsled);
            if (needUpdateBsledList != null && needUpdateBsledList.size() > 0) {
                allUpdateBsledList.addAll(needUpdateBsledList);
                List<DynamicObject> bsledUpdateList = this.dealBsledRecordDatas(identifyNum, needUpdateBsledList, bsledRecordHelper, bizDataBsledDateMap);
                needSaveBsledRecordList.addAll(bsledUpdateList);
                this.bsledChangeLog(needSaveLogList, needUpdateBsledList, identifyNum, bizDataBsledDateMap);
                this.bsledChangeSendHpdi(updateBizDataList, needUpdateBsledList, identifyNum);
            }
            bizDataObj.set("salaryfile", (Object)salaryFileId);
        }
        SWCDataServiceHelper recurBizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        DynamicObject[] updateSalaryFiles = new DynamicObject[bizDataList.size()];
        for (int index = 0; index < bizDataList.size(); ++index) {
            updateSalaryFiles[index] = (DynamicObject)bizDataList.get(index);
        }
        recurBizDataHelper.update(updateSalaryFiles);
        if (allUpdateBsledList.size() > 0) {
            DynamicObject[] updateBsleds = new DynamicObject[allUpdateBsledList.size()];
            for (int index = 0; index < allUpdateBsledList.size(); ++index) {
                updateBsleds[index] = (DynamicObject)allUpdateBsledList.get(index);
            }
            recurBizDataHelper.update(updateBsleds);
        }
        if (needSaveBsledRecordList.size() > 0) {
            DynamicObject[] bsledSaveDatas = new DynamicObject[needSaveBsledRecordList.size()];
            for (int index = 0; index < needSaveBsledRecordList.size(); ++index) {
                bsledSaveDatas[index] = (DynamicObject)needSaveBsledRecordList.get(index);
            }
            bsledRecordHelper.save(bsledSaveDatas);
        }
        if (needSaveLogList.size() > 0) {
            BizDataModifyRecHelper.saveBizDataModifyRec(needSaveLogList);
        }
        if (updateBizDataList.size() > 0) {
            Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
            log.info("RecurbizDataPayRollGrpDirectTransOp needPushHpdiDataList result is:{}", (Object)result);
        }
    }

    private void bsledChangeSendHpdi(List<Map<String, Object>> updateBizDataList, List<DynamicObject> needUpdateBsledList, String identifyNum) {
        for (DynamicObject needUpdateObj : needUpdateBsledList) {
            HashMap<String, Object> needPushHpdiDataMap = new HashMap<String, Object>(16);
            String bizDataCode = needUpdateObj.getString("identifynumber");
            needPushHpdiDataMap.put("bizdatacode", bizDataCode);
            needPushHpdiDataMap.put("operatebizdatacode", identifyNum);
            Long oldBizItemId = needUpdateObj.getLong("bizitem.id");
            needPushHpdiDataMap.put("bizitem", oldBizItemId);
            Long updateSalaryFileId = needUpdateObj.getLong("salaryfile.id");
            needPushHpdiDataMap.put("salaryfile", updateSalaryFileId);
            needPushHpdiDataMap.put("modeltype", "1");
            needPushHpdiDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            needPushHpdiDataMap.put("bsled", needUpdateObj.getDate("bsled"));
            needPushHpdiDataMap.put("modifier", RequestContext.get().getCurrUserId());
            updateBizDataList.add(needPushHpdiDataMap);
        }
    }

    private void salaryFileChangeSendHpdi(List<Map<String, Object>> updateBizDataList, DynamicObject bizDataObj, Map<String, Map<String, Object>> salaryFileMap) {
        String personId = bizDataObj.getString("salaryfile.person.id");
        Map<String, Object> salaryFileInfo = salaryFileMap.get(personId);
        if (salaryFileInfo == null || salaryFileInfo.size() == 0) {
            return;
        }
        Long newSalaryFileId = (Long)salaryFileInfo.get("salaryFileId");
        HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
        updateBizDataMap.put("bizdatacode", bizDataObj.getString("identifynumber"));
        updateBizDataMap.put("bizitem", bizDataObj.getLong("bizitem.id"));
        updateBizDataMap.put("salaryfile", newSalaryFileId);
        updateBizDataMap.put("modeltype", "1");
        updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
        updateBizDataMap.put("modifier", RequestContext.get().getCurrUserId());
        updateBizDataList.add(updateBizDataMap);
    }

    private void bsledChangeLog(List<BizDataModifyRecEntity> needSaveLogList, List<DynamicObject> needUpdateBsledList, String identifyNum, Map<String, Date> bizDataBsledDateMap) {
        for (DynamicObject needUpdateObj : needUpdateBsledList) {
            Date afterUpdateBsed;
            BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(needUpdateObj.getLong("salaryfile.id")));
            String bizDataCode = needUpdateObj.getString("identifynumber");
            dataModifyRec.setBizDataNum(bizDataCode);
            dataModifyRec.setOpBizDataNum(identifyNum);
            Long bizItemId = needUpdateObj.getLong("bizitem.id");
            dataModifyRec.setBizItemId(bizItemId);
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + bizItemId);
            if (beforeBsled != null) {
                String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
                dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
            }
            if ((afterUpdateBsed = needUpdateObj.getDate("bsled")) != null) {
                String afterUpdateBsedStr = SWCDateTimeUtils.format((Date)afterUpdateBsed, (String)"yyyy-MM-dd");
                dataModifyRec.setAfterUpdate(afterUpdateBsedStr);
            }
            dataModifyRec.setDataSources(needUpdateObj.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            dataModifyRec.setDataId(Long.valueOf(needUpdateObj.getLong("id")));
            dataModifyRec.setModelType("1");
            needSaveLogList.add(dataModifyRec);
        }
    }

    private void salaryFileChangeLog(List<BizDataModifyRecEntity> needSaveLogList, DynamicObject bizDataObj, Map<String, Map<String, Object>> salaryFileMap) {
        String personId = bizDataObj.getString("salaryfile.person.id");
        Map<String, Object> salaryFileInfo = salaryFileMap.get(personId);
        if (salaryFileInfo == null || salaryFileInfo.size() == 0) {
            return;
        }
        Long newSalaryFileId = (Long)salaryFileInfo.get("salaryFileId");
        BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
        dataModifyRec.setDataId(Long.valueOf(bizDataObj.getLong("id")));
        dataModifyRec.setSalaryFileId(newSalaryFileId);
        dataModifyRec.setBizItemId(Long.valueOf(bizDataObj.getLong("bizitem.id")));
        dataModifyRec.setBizDataNum(bizDataObj.getString("identifynumber"));
        dataModifyRec.setDataSources(bizDataObj.getString("datasources"));
        dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.SALARYFILE.getCode());
        dataModifyRec.setBeforeUpdate(bizDataObj.getString("salaryfile.number"));
        dataModifyRec.setAfterUpdate((String)salaryFileInfo.get("salaryFileNumber"));
        dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
        dataModifyRec.setModelType("1");
        dataModifyRec.setBizItemGroupId(Long.valueOf(bizDataObj.getLong("bizdataaccesstpl.id")));
        needSaveLogList.add(dataModifyRec);
    }

    private List<DynamicObject> dealBsledRecordDatas(String identifyNum, List<DynamicObject> needUpdateBsledList, SWCDataServiceHelper bsledRecordHelper, Map<String, Date> bizDataBsledDateMap) {
        ArrayList<DynamicObject> retList = new ArrayList<DynamicObject>(10);
        for (DynamicObject updateObj : needUpdateBsledList) {
            DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
            Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
            bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
            Long oldBizItemId = updateObj.getLong("bizitem.id");
            bsledRecordObj.set("bizitem", (Object)oldBizItemId);
            String bizDataCode = updateObj.getString("identifynumber");
            bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
            bsledRecordObj.set("opbizdatacode", (Object)identifyNum);
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
            if (beforeBsled != null) {
                bsledRecordObj.set("beforebsled", (Object)beforeBsled);
            }
            bsledRecordObj.set("afterbsled", (Object)updateObj.getDate("bsled"));
            bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            bsledRecordObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            bsledRecordObj.set("modifytime", (Object)new Date());
            retList.add(bsledRecordObj);
        }
        return retList;
    }
}

