/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.cal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsas.opplugin.validator.cal.CalTableAuditValidator;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.enums.TaxDataBizStatusEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalTableAuditOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(CalTableAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("calstatus");
        fieldKeys.add("paystatus");
        fieldKeys.add("salaryfile");
        fieldKeys.add("caltask");
        fieldKeys.add("onholdstatus");
        fieldKeys.add("taxstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CalTableAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] checkedDyObjs = e.getDataEntities();
        DynamicObject calPerson = checkedDyObjs[0];
        long taskId = calPerson.getLong("caltask.id");
        Boolean taxCalEnableStatus = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        HSASCalListService calService = new HSASCalListService();
        if (taxCalEnableStatus.booleanValue()) {
            ArrayList<Long> rows = new ArrayList<Long>(10);
            for (DynamicObject checkedDyObj : checkedDyObjs) {
                rows.add(checkedDyObj.getLong("id"));
            }
            String langeCode = this.getOption().getVariableValue("langCode");
            Long countryId = calPerson.getLong("caltask.country.id");
            Date payDate = calPerson.getDate("caltask.payDate");
            this.callTaxService(rows, String.valueOf(countryId), langeCode, payDate);
        }
        try (TXHandle txHandle = TX.required();){
            long startTime = System.currentTimeMillis();
            calService.doAudit(checkedDyObjs, taxCalEnableStatus);
            log.info("{}\u5ba1\u6838\u65f6\u4fee\u6539\u6570\u636e\u5e93\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getTraceId(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private Map<String, Object> callTaxService(List<Long> rows, String countryId, String langeCode, Date payDate) {
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("srcType", "1");
        param.put("langCode", langeCode);
        param.put("payDate", payDate);
        param.put("status", TaxDataBizStatusEnum.EXPORT.getCode());
        param.put("country", countryId);
        param.put("data", rows);
        return (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"updateSrcDataStatus", (Object[])new Object[]{param});
    }
}

