/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.cal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsas.opplugin.validator.cal.CalTableUnAuditValidator;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.enums.TaxDataBizStatusEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalTableUnAuditOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(CalTableUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("person");
        fieldKeys.add("calstatus");
        fieldKeys.add("paystatus");
        fieldKeys.add("salaryfile");
        fieldKeys.add("allotstatus");
        fieldKeys.add("caltask");
        fieldKeys.add("onholdstatus");
        fieldKeys.add("taxstatus");
        fieldKeys.add("salarystatus");
        fieldKeys.add("bizdatagenstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CalTableUnAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] checkedDyObjs = e.getDataEntities();
        DynamicObject calPerson = checkedDyObjs[0];
        long taskId = calPerson.getLong("caltask.id");
        String allotCalPersonIdListStr = this.getOption().getVariableValue("allotCalPersonIdList");
        String[] allotCalPersonIds = null;
        if (SWCStringUtils.isNotEmpty((String)allotCalPersonIdListStr)) {
            allotCalPersonIds = allotCalPersonIdListStr.split(",");
        }
        HSASCalListService calService = new HSASCalListService();
        Boolean taxCalEnableStatus = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        ArrayList<Long> personIdList = new ArrayList<Long>(checkedDyObjs.length);
        for (DynamicObject checkedDyObj : checkedDyObjs) {
            personIdList.add(checkedDyObj.getLong("id"));
        }
        GenBizDataService service = new GenBizDataService();
        List calPersonObjs = service.getCalPersonObjs(personIdList, "47162f66000000ac");
        if (SWCListUtils.isEmpty((List)calPersonObjs)) {
            return;
        }
        List invalidPersonIdList = calPersonObjs.stream().filter(v1 -> SWCStringUtils.equals((String)v1.getString("bizdatagenstatus"), (String)"2")).map(single -> single.getLong("id")).collect(Collectors.toList());
        personIdList.removeAll(invalidPersonIdList);
        if (taxCalEnableStatus.booleanValue()) {
            String langeCode = this.getOption().getVariableValue("langCode");
            Long l = calPerson.getLong("caltask.country.id");
            Date payDate = calPerson.getDate("caltask.payDate");
            this.callTaxService(personIdList, String.valueOf(l), langeCode, payDate);
        }
        ArrayList validPersonObjList = Lists.newArrayListWithExpectedSize((int)checkedDyObjs.length);
        for (DynamicObject checkedDyObj : checkedDyObjs) {
            long personId = checkedDyObj.getLong("id");
            if (!personIdList.contains(personId)) continue;
            validPersonObjList.add(checkedDyObj);
        }
        try (TXHandle tXHandle = TX.required();){
            long startTime = System.currentTimeMillis();
            calService.doUnAudit(validPersonObjList.toArray(new DynamicObject[validPersonObjList.size()]), allotCalPersonIds, taxCalEnableStatus);
            log.info("{}\u53cd\u5ba1\u6838\u65f6\u4fee\u6539\u6570\u636e\u5e93\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getTraceId(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private Map<String, Object> callTaxService(List<Long> rows, String countryId, String langeCode, Date payDate) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("srcType", "1");
        param.put("langCode", langeCode);
        param.put("payDate", payDate);
        param.put("status", TaxDataBizStatusEnum.NEW.getCode());
        param.put("country", countryId);
        param.put("data", rows);
        return (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"updateSrcDataStatus", (Object[])new Object[]{param});
    }
}

