/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.calresulttpl;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplServiceHelper;
import kd.swc.hsas.opplugin.web.calresulttpl.CalResultTplSubmitValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalResultTplSubmitOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("resultlist");
        e.getFieldKeys().add("payrollgroups");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalResultTplSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] defaultInfo;
        DynamicObject[] checkedDyObjs = e.getDataEntities();
        DynamicObject calResultTplObj = checkedDyObjs[0];
        Long calResultTplId = calResultTplObj.getLong("id");
        CalResultTplServiceHelper helper = new CalResultTplServiceHelper();
        DynamicObjectCollection payRollGroups = calResultTplObj.getDynamicObjectCollection("payrollgroups");
        if (payRollGroups == null || payRollGroups.size() == 0) {
            return;
        }
        List payRollGroupIds = payRollGroups.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        for (DynamicObject dataObj : defaultInfo = helper.getCalResultTplIsDefaultInfo(payRollGroupIds, calResultTplId.longValue())) {
            dataObj.set("isdefault", null);
        }
        helper.updateCalResultDefaultInfo(defaultInfo);
    }
}

