/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.cloudcolla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudCollaSyncOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("datastatus");
        e.getFieldKeys().add("sourcevid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        super.beginOperationTransaction(e);
        Map<String, Object> messageData = null;
        String entityId = this.billEntityType.getName();
        switch (operationKey = e.getOperationKey()) {
            case "save": {
                messageData = this.getsyncMessageData(e.getDataEntities()[0], entityId, operationKey);
                break;
            }
            case "formsubmit": {
                messageData = this.getsyncMessageData(e.getDataEntities()[0], entityId, operationKey);
                break;
            }
            case "delete": {
                messageData = this.getDeleteMesageData(e.getDataEntities(), entityId);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                messageData = this.getStatusOrEnableChangeMessageData(e.getDataEntities(), "statuschange", Stream.of("status", "datastatus", "sourcevid").collect(Collectors.toList()), entityId);
                break;
            }
            case "disable": 
            case "enable": {
                messageData = this.getStatusOrEnableChangeMessageData(e.getDataEntities(), "enablechange", Stream.of("enable").collect(Collectors.toList()), entityId);
                break;
            }
        }
        if (null != messageData && !messageData.isEmpty()) {
            this.publishSyncMsg(messageData);
        }
    }

    private void publishSyncMsg(Map<String, Object> messageData) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hpdi_opsync_queue");){
            publisher.publishInDbTranscation("swc", messageData);
        }
    }

    private Map<String, Object> getsyncMessageData(DynamicObject dataEntity, String pageEntityId, String operationKey) {
        Map<String, Object> messageData = null;
        Boolean isUpdate = this.getOption().containsVariable("update");
        if (isUpdate.booleanValue()) {
            String status = dataEntity.getString("status");
            if (SWCStringUtils.equals((String)operationKey, (String)"save")) {
                switch (status) {
                    case "A": {
                        messageData = this.getAllUpdateMessageData(dataEntity, pageEntityId);
                        break;
                    }
                    default: {
                        messageData = this.getSomeUpdateMessageData(dataEntity, pageEntityId);
                        break;
                    }
                }
            } else {
                messageData = this.getAllUpdateMessageData(dataEntity, pageEntityId);
            }
        } else {
            messageData = this.getAddNewMessageData(dataEntity, pageEntityId);
        }
        return messageData;
    }

    private Map<String, Object> getAddNewMessageData(DynamicObject dyobj, String pageEntityId) {
        Map<String, Object> syncData = this.getAllFieldData(dyobj, pageEntityId);
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        if (!syncData.isEmpty()) {
            this.assembleMessageData(messageData, "addnew", syncData, pageEntityId);
        }
        return messageData;
    }

    private Map<String, Object> getAllUpdateMessageData(DynamicObject dyobj, String pageEntityId) {
        Map<String, Object> syncData = this.getAllFieldData(dyobj, pageEntityId);
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        if (!syncData.isEmpty()) {
            this.assembleMessageData(messageData, "update", syncData, pageEntityId);
        }
        return messageData;
    }

    private Map<String, Object> getAllFieldData(DynamicObject dyobj, String pageEntityId) {
        MainEntityType mainEntityType = (MainEntityType)dyobj.getDataEntityType();
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, Object> syncData = new HashMap<String, Object>(16);
        for (Map.Entry entityTypeEntry : entityTypeMap.entrySet()) {
            List<Map<String, Object>> datas;
            String entityId = (String)entityTypeEntry.getKey();
            EntityType entityType = (EntityType)entityTypeEntry.getValue();
            Map fieldMap = entityType.getFields();
            if (entityType instanceof BasedataEntityType) {
                Map<String, Object> data = this.genBasedataEntityTypeData(dyobj, fieldMap);
                if (data.isEmpty()) continue;
                syncData.put(this.repalceHsasToHpdi(entityId), data);
                continue;
            }
            if (entityType instanceof SubEntryType || !(entityType instanceof EntryType) || (datas = this.genEntryTypeData(entityId, dyobj, fieldMap)).isEmpty()) continue;
            syncData.put(entityId, datas);
        }
        return syncData;
    }

    private List<Map<String, Object>> genEntryTypeData(String entryentityId, DynamicObject dyobj, Map<String, IDataEntityProperty> fieldMap) {
        DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection(entryentityId);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        for (DynamicObject entryentity : entryentities) {
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            for (Map.Entry<String, IDataEntityProperty> fieldEntry : fieldMap.entrySet()) {
                String fieldKey = fieldEntry.getKey();
                IDataEntityProperty prop = fieldEntry.getValue();
                if (prop instanceof BasedataProp) {
                    data.put(fieldKey, entryentity.get(fieldKey + ".id"));
                    continue;
                }
                if (prop instanceof TextProp) {
                    data.put(fieldKey, entryentity.getString(fieldKey));
                    continue;
                }
                data.put(fieldKey, entryentity.get(fieldKey));
            }
            data.put("id", entryentity.get("id"));
            data.put("seq", entryentity.get("seq"));
            datas.add(data);
        }
        return datas;
    }

    private Map<String, Object> genBasedataEntityTypeData(DynamicObject dyobj, Map<String, IDataEntityProperty> fieldMap) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        for (Map.Entry<String, IDataEntityProperty> fieldEntry : fieldMap.entrySet()) {
            String fieldKey = fieldEntry.getKey();
            IDataEntityProperty prop = fieldEntry.getValue();
            if (prop instanceof BasedataProp) {
                data.put(fieldKey, dyobj.get(fieldKey + ".id"));
                continue;
            }
            if (prop instanceof TextProp) {
                data.put(fieldKey, dyobj.getString(fieldKey));
                continue;
            }
            data.put(fieldKey, dyobj.get(fieldKey));
        }
        data.put("id", dyobj.get("id"));
        return data;
    }

    private Map<String, Object> getSomeUpdateMessageData(DynamicObject dyobj, String pageEntityId) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", dyobj.getLong("id"));
        data.put("alias", dyobj.getString("alias"));
        data.put("description", dyobj.getString("description"));
        HashMap<String, HashMap<String, Object>> syncData = new HashMap<String, HashMap<String, Object>>(16);
        syncData.put(this.repalceHsasToHpdi(pageEntityId), data);
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        if (!syncData.isEmpty()) {
            this.assembleMessageData(messageData, "update", syncData, pageEntityId);
        }
        return messageData;
    }

    private Map<String, Object> getDeleteMesageData(DynamicObject[] dyobjs, String pageEntityId) {
        ArrayList<Long> deleteIds = new ArrayList<Long>(10);
        for (DynamicObject dyobj : dyobjs) {
            deleteIds.add(dyobj.getLong("id"));
        }
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        if (!deleteIds.isEmpty()) {
            this.assembleMessageData(messageData, "delete", deleteIds, pageEntityId);
        }
        return messageData;
    }

    private Map<String, Object> getStatusOrEnableChangeMessageData(DynamicObject[] dyobjs, String collaTag, List<String> FieldKeys, String pageEntityId) {
        HashMap updateIdStatusRel = new HashMap(16);
        for (DynamicObject dyobj : dyobjs) {
            HashMap<String, Object> tempValue = new HashMap<String, Object>(FieldKeys.size());
            for (String fieldKey : FieldKeys) {
                tempValue.put(fieldKey, dyobj.get(fieldKey));
            }
            updateIdStatusRel.put(dyobj.getLong("id"), tempValue);
        }
        HashMap<String, Object> messageData = new HashMap<String, Object>(16);
        if (!updateIdStatusRel.isEmpty()) {
            this.assembleMessageData(messageData, collaTag, updateIdStatusRel, pageEntityId);
        }
        return messageData;
    }

    private void assembleMessageData(Map<String, Object> messageData, String collaTag, Object collaData, String pageEntityId) {
        messageData.put("tag", collaTag);
        messageData.put("data", collaData);
        messageData.put("entity", this.repalceHsasToHpdi(pageEntityId));
    }

    private String repalceHsasToHpdi(String entityId) {
        return entityId.replace("hsas", "hpdi");
    }
}

