/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.file;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileDepEmpSaveValidator;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileDemEmpSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileDemEmpSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("employee.person");
        fieldKeys.add("person");
        fieldKeys.add("useorg");
        fieldKeys.add("employee");
        fieldKeys.add("empposinfo");
        fieldKeys.add("depemp");
        fieldKeys.add("depemp.startdate");
        fieldKeys.add("depemp.enddate");
        fieldKeys.add("depemp.employee");
        fieldKeys.add("payrollgroup");
        fieldKeys.add("payrollgroup.firstbsed");
        fieldKeys.add("boid");
        fieldKeys.add("bsed");
        fieldKeys.add("bsled");
        fieldKeys.add("status");
        fieldKeys.add("paystatus");
        fieldKeys.add("isupdatepayenddate");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.getValidators().add(new SalaryFileDepEmpSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String validate = (String)this.operateOption.getVariables().get("op");
        if (SWCStringUtils.equals((String)"validate", (String)validate)) {
            args.setCancel(true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(Arrays.stream(dataEntities).collect(Collectors.toMap(dyc -> dyc.getString("boid"), dyc -> dyc, (k1, k2) -> k1)).values());
        this.saveOrgTeams(fileList);
    }

    private void saveOrgTeams(List<DynamicObject> fileList) {
        RefObject refObject = new RefObject();
        this.getOption().tryGetVariableValue("empIsEndWhenStopPay", refObject);
        String empIsEndWhenStopPayJson = (String)refObject.getValue();
        HashMap<String, String> empIsEndWhenStopPayMap = null;
        if (!SWCStringUtils.isEmpty((String)empIsEndWhenStopPayJson)) {
            try {
                empIsEndWhenStopPayMap = SWCJSONUtils.convertJSONObjectToMap((Object)empIsEndWhenStopPayJson);
            }
            catch (Exception ex) {
                LOGGER.info("parse json error. input ={}", (Object)empIsEndWhenStopPayJson, (Object)ex);
            }
        }
        if (empIsEndWhenStopPayMap == null) {
            empIsEndWhenStopPayMap = new HashMap<String, String>(16);
        }
        for (DynamicObject dynamicObject : fileList) {
            long salaryFileId = dynamicObject.getLong("id");
            boolean isUpdatePayEndData = dynamicObject.getBoolean("isupdatepayenddate");
            String status = dynamicObject.getString("status");
            empIsEndWhenStopPayMap.compute(String.valueOf(salaryFileId), (key, lastValue) -> {
                if ((isUpdatePayEndData || "1".equals(lastValue)) && "C".equalsIgnoreCase(status)) {
                    return "1";
                }
                return "0";
            });
        }
        ArrayList datas = new ArrayList(10);
        List salaryFileBoIds = fileList.stream().map(item -> item.getLong("boid")).collect(Collectors.toList());
        Map mainWorkRoleBySalaryFileIds = SalaryFileEmpPosOrgRelHelper.getMainWorkRoleBySalaryFileIds(salaryFileBoIds);
        for (DynamicObject dynamicObject : fileList) {
            String id = dynamicObject.getString("id");
            long boId = dynamicObject.getLong("boid");
            DynamicObject depemp = dynamicObject.getDynamicObject("depemp");
            long workRoleId = depemp.getLong("id");
            Date bsed = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)dynamicObject.getDate("bsed"));
            Date bsled = dynamicObject.getDate("bsled") == null ? SalaryFileEmpPosOrgRelHelper.getMaxDate() : SalaryFileEmpPosOrgRelHelper.getDateDay((Date)dynamicObject.getDate("bsled"));
            HashMap<String, Serializable> data = new HashMap<String, Serializable>(16);
            ArrayList workRoles = new ArrayList(10);
            HashMap<String, Object> workRole = new HashMap<String, Object>(16);
            workRole.put("workRole", depemp);
            workRole.put("workRoleId", workRoleId);
            workRole.put("isMainWorkRole", mainWorkRoleBySalaryFileIds.getOrDefault(boId, Collections.emptySet()).contains(workRoleId) ? "1" : "0");
            workRole.put("payStartDate", bsed);
            workRole.put("salaryFileBsed", bsed);
            workRole.put("isStopPayEndDate", empIsEndWhenStopPayMap.getOrDefault(id, "0"));
            workRole.put("payEndDate", bsled);
            workRole.put("payStatus", dynamicObject.getString("paystatus"));
            workRoles.add(workRole);
            data.put("salaryFileId", Long.valueOf(boId));
            data.put("workRoles", workRoles);
            datas.add(data);
        }
        OperationResult tempOpResult = SalaryFileEmpPosOrgRelHelper.saveEmpPosOrgRel(datas);
        if (tempOpResult != null && !tempOpResult.isSuccess()) {
            List allErrorOrValidateInfo = tempOpResult.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                throw new KDBizException(tempOpResult.getMessage());
            }
            throw new KDBizException(allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator())));
        }
    }
}

