/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.insurance;

import java.text.ParseException;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.swc.hsas.opplugin.validator.insurance.InsuranceDataChangeValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class InsuranceDataChangeOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("withholddate");
        e.getFieldKeys().add("withholdtype");
        e.getFieldKeys().add("sinsurperiodnumber");
        e.getFieldKeys().add("usestatus");
        e.getFieldKeys().add("person.name");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InsuranceDataChangeValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        Date withholddate;
        String withholddateStr = this.getOption().getVariableValue("withholddate");
        String withholdtype = this.getOption().getVariableValue("withholdtype");
        try {
            withholddate = SWCDateTimeUtils.parseDate((String)withholddateStr, (String)"yyyy-MM");
        }
        catch (ParseException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("withholdtype", (Object)withholdtype);
            dataEntity.set("withholddate", (Object)withholddate);
            dataEntity.set("modifier", (Object)currUserId);
            dataEntity.set("modifytime", (Object)now);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_insurancedata");
        helper.save(dataEntities);
    }
}

