/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.onhold;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldMsgHelper;
import kd.swc.hsas.opplugin.validator.onhold.OnHoldBillSubmitValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class OnHoldBillSubmitOp
extends SWCDataBaseOp {
    private static final Log logger = LogFactory.getLog(OnHoldBillSubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OnHoldBillSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] dynamicObjects = this.findOnHoldBill(dataEntities);
        this.updateSubmit(dynamicObjects);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("salaryfile.number");
        e.getFieldKeys().add("salaryfile.id");
        e.getFieldKeys().add("caltableid");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("org.id");
        e.getFieldKeys().add("msgstatus");
        e.getFieldKeys().add("person.person.name");
        e.getFieldKeys().add("person.empnumber");
        e.getFieldKeys().add("caltask.id");
        e.getFieldKeys().add("person.person.number");
        e.getFieldKeys().add("status");
    }

    private DynamicObject[] findOnHoldBill(DynamicObject[] dataEntities) {
        HashSet<Long> onHoldIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject object : dataEntities) {
            onHoldIdSet.add(object.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        String selectProperties = "id,status,salaryfile,onholdreason.id,cause.id,remark,caltableid,releasedate,modifytime,modifier,startdate,enddate,person.name,person.empnumber,salaryfile.number,isallowcal";
        DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{new QFilter("id", "in", onHoldIdSet)});
        return dynamicObjects;
    }

    private void updateSubmit(DynamicObject[] dynamicObjects) {
        int selectedSize = dynamicObjects.length;
        HashSet<Long> calTableIdSet = new HashSet<Long>(selectedSize);
        HashMap<Long, Date> cacheOnHoldBillMap = new HashMap<Long, Date>(selectedSize);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(selectedSize);
        HashMap<Long, Date> cacheSalaryFileMap = new HashMap<Long, Date>(selectedSize);
        ArrayList<DynamicObject> salaryOnHoldList = new ArrayList<DynamicObject>(selectedSize);
        for (DynamicObject onHoldObj : dynamicObjects) {
            Long caltableId = onHoldObj.getLong("caltableid");
            if (caltableId > 0L) {
                calTableIdSet.add(caltableId);
                cacheOnHoldBillMap.put(caltableId, onHoldObj.getDate("startdate"));
                continue;
            }
            salaryOnHoldList.add(onHoldObj);
            Long salaryFileId = onHoldObj.getLong("salaryfile.id");
            salaryFileIdSet.add(salaryFileId);
            cacheSalaryFileMap.put(salaryFileId, onHoldObj.getDate("startdate"));
        }
        this.updateOnHoldBill(dynamicObjects);
        this.insertOnHoldFile(salaryOnHoldList);
        Map calPersonOnHoldMap = OnHoldBillHelper.updateCalTableBySalaryFile(salaryFileIdSet, cacheSalaryFileMap);
        Date currDate = new Date();
        Long currUserId = RequestContext.get().getCurrUserId();
        if (calPersonOnHoldMap != null && calPersonOnHoldMap.size() > 0) {
            OnHoldBillHelper.updatePayDetailByCalPerson((Date)currDate, (Long)currUserId, (Map)calPersonOnHoldMap);
            OnHoldBillHelper.updateAllotDetailByCalPerson((Date)currDate, (Long)currUserId, (Map)calPersonOnHoldMap);
        }
        if (CollectionUtils.isEmpty(calTableIdSet)) {
            return;
        }
        OnHoldBillHelper.updateCalTable(calTableIdSet, cacheOnHoldBillMap);
        OnHoldBillHelper.updatePayDetail((Date)currDate, (Long)currUserId, calTableIdSet);
        OnHoldBillHelper.updateAllotDetail((Date)currDate, (Long)currUserId, calTableIdSet);
    }

    private void insertOnHoldFile(List<DynamicObject> onHoldList) {
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        DynamicObjectCollection onHoldCollection = new DynamicObjectCollection();
        Long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject onHoldObj : onHoldList) {
            DynamicObject dynamicObject = onHoldFileHelper.generateEmptyDynamicObject();
            dynamicObject.set("status", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            dynamicObject.set("description", (Object)onHoldObj.getString("remark"));
            dynamicObject.set("startdate", (Object)onHoldObj.getDate("startdate"));
            dynamicObject.set("salaryfile", (Object)onHoldObj.getLong("salaryfile.id"));
            dynamicObject.set("cause", (Object)onHoldObj.getLong("cause.id"));
            Date releaseDate = onHoldObj.getDate("releasedate");
            dynamicObject.set("releasedate", (Object)releaseDate);
            if (releaseDate != null) {
                Date currentDate = new Date();
                Date formateDate = null;
                try {
                    formateDate = SWCDateTimeUtils.formatDateToDate((Date)currentDate, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    logger.error("formate date error:{}", (Object)e.getMessage());
                }
                if (formateDate != null && releaseDate.getTime() <= currentDate.getTime()) {
                    dynamicObject.set("status", (Object)OnHoldStatusEnum.STATUS_TOPAY.getCode());
                }
            }
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("isallowcal", onHoldObj.get("isallowcal"));
            onHoldCollection.add((Object)dynamicObject);
        }
        onHoldFileHelper.save(onHoldCollection);
    }

    private void updateOnHoldBill(DynamicObject[] onHoldObjectArr) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        Date currentDate = new Date();
        Long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject onHold : onHoldObjectArr) {
            Date releaseDate = onHold.getDate("releasedate");
            onHold.set("status", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            if (!SWCObjectUtils.isEmpty((Object)releaseDate) && releaseDate.before(currentDate)) {
                onHold.set("status", (Object)OnHoldStatusEnum.STATUS_TOPAY.getCode());
            }
            onHold.set("modifytime", (Object)new Date());
            onHold.set("modifier", (Object)currUserId);
        }
        onHoldHelper.update(onHoldObjectArr);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try {
            OnHoldMsgHelper.dispatchSendMsgTask((String)"onholdbillsubmit", (DynamicObject[])e.getDataEntities());
        }
        catch (Exception ex) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff1a{}", (Object)ex.getMessage());
        }
    }
}

