/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.prorationrule;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.opplugin.validator.prorationrule.ProrationRuleSaveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class ProrationRuleSaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("numerator");
        fieldKeys.add("denominator");
        fieldKeys.add("country");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProrationRuleSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationrule");
        HashSet<Long> idSet = new HashSet<Long>(datas.length);
        HashSet<Long> boIdSet = new HashSet<Long>(datas.length);
        for (DynamicObject data : datas) {
            idSet.add(data.getLong("id"));
            boIdSet.add(data.getLong("boid"));
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.or(new QFilter("id", "in", boIdSet));
        DynamicObject[] existDatas = helper.query("id,boid,areatype,country,number", new QFilter[]{filter});
        if (existDatas != null && existDatas.length > 0) {
            Map<Long, DynamicObject> existMap = Arrays.stream(existDatas).collect(Collectors.toMap(existData -> existData.getLong("id"), existData -> existData));
            for (DynamicObject data : datas) {
                DynamicObject existData2 = existMap.get(data.getLong("boid"));
                if (existData2 == null) {
                    existData2 = existMap.get(data.getLong("id"));
                }
                if (existData2 == null) continue;
                data.set("areatype", existData2.get("areatype"));
                data.set("country", existData2.get("country"));
                data.set("number", existData2.get("number"));
            }
        }
    }
}

